/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iso.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.standards.iso.MicData;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=API_GetMicDataDefault.class)
public abstract class API_GetMicData
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public MicData evaluate(String mic) {
        MicData micData;
        MicData.MicDataBuilder micDataBuilder = this.doEvaluate(mic);
        if (micDataBuilder == null) {
            micData = null;
        } else {
            micData = micDataBuilder.build();
            this.objectValidator.validate(MicData.class, (RosettaModelObject)micData);
        }
        return micData;
    }

    protected abstract MicData.MicDataBuilder doEvaluate(String var1);

    public static class API_GetMicDataDefault
    extends API_GetMicData {
        @Override
        protected MicData.MicDataBuilder doEvaluate(String mic) {
            MicData.MicDataBuilder micData = MicData.builder();
            return this.assignOutput(micData, mic);
        }

        protected MicData.MicDataBuilder assignOutput(MicData.MicDataBuilder micData, String mic) {
            return Optional.ofNullable(micData).map(o -> o.prune()).orElse(null);
        }
    }
}

