/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.functions.BusinessCenterHolidays;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.records.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=BusinessCenterHolidaysMultipleDefault.class)
public abstract class BusinessCenterHolidaysMultiple
implements RosettaFunction {
    @Inject
    protected BusinessCenterHolidays businessCenterHolidays;

    public List<Date> evaluate(List<BusinessCenterEnum> businessCenters) {
        List<Date> holidayDates = this.doEvaluate(businessCenters);
        return holidayDates;
    }

    protected abstract List<Date> doEvaluate(List<BusinessCenterEnum> var1);

    public static class BusinessCenterHolidaysMultipleDefault
    extends BusinessCenterHolidaysMultiple {
        @Override
        protected List<Date> doEvaluate(List<BusinessCenterEnum> businessCenters) {
            if (businessCenters == null) {
                businessCenters = Collections.emptyList();
            }
            ArrayList<Date> holidayDates = new ArrayList<Date>();
            return this.assignOutput(holidayDates, businessCenters);
        }

        protected List<Date> assignOutput(List<Date> holidayDates, List<BusinessCenterEnum> businessCenters) {
            MapperListOfLists thenArg0 = MapperC.of(businessCenters).mapItemToList(item -> MapperC.of(this.businessCenterHolidays.evaluate((BusinessCenterEnum)((Object)((Object)item.get())))));
            MapperC thenArg1 = thenArg0.flattenList();
            MapperC thenArg2 = ExpressionOperatorsNullSafe.distinct((Mapper)thenArg1);
            holidayDates.addAll(thenArg2.sort().getMulti());
            return holidayDates;
        }
    }
}

