/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.CompareOp;
import cdm.base.math.Quantity;
import cdm.base.math.UnitType;
import cdm.base.math.functions.CompareNumbers;
import cdm.base.math.functions.FilterQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=CompareQuantityByUnitOfAmountDefault.class)
public abstract class CompareQuantityByUnitOfAmount
implements RosettaFunction {
    @Inject
    protected CompareNumbers compareNumbers;
    @Inject
    protected FilterQuantity filterQuantity;

    public Boolean evaluate(List<? extends Quantity> quantity1, CompareOp op, List<? extends Quantity> quantity2, UnitType unitOfAmount) {
        Boolean result = this.doEvaluate(quantity1, op, quantity2, unitOfAmount);
        return result;
    }

    protected abstract Boolean doEvaluate(List<? extends Quantity> var1, CompareOp var2, List<? extends Quantity> var3, UnitType var4);

    public static class CompareQuantityByUnitOfAmountDefault
    extends CompareQuantityByUnitOfAmount {
        @Override
        protected Boolean doEvaluate(List<? extends Quantity> quantity1, CompareOp op, List<? extends Quantity> quantity2, UnitType unitOfAmount) {
            if (quantity1 == null) {
                quantity1 = Collections.emptyList();
            }
            if (quantity2 == null) {
                quantity2 = Collections.emptyList();
            }
            Boolean result = null;
            return this.assignOutput(result, quantity1, op, quantity2, unitOfAmount);
        }

        protected Boolean assignOutput(Boolean result, List<? extends Quantity> quantity1, CompareOp op, List<? extends Quantity> quantity2, UnitType unitOfAmount) {
            MapperListOfLists thenArg = MapperC.of(this.filterQuantity.evaluate(quantity1, unitOfAmount)).mapItemToList(q1 -> MapperC.of(this.filterQuantity.evaluate(quantity2, unitOfAmount)).mapItem(q2 -> MapperS.of((Object)this.compareNumbers.evaluate((BigDecimal)q1.map("getValue", quantity -> quantity.getValue()).get(), op, (BigDecimal)q2.map("getValue", quantity -> quantity.getValue()).get()))));
            result = (Boolean)ExpressionOperatorsNullSafe.areEqual((Mapper)thenArg.flattenList(), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).asMapper().get();
            return result;
        }
    }
}

