/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.functions.ArithmeticOperation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=VectorScalarOperationDefault.class)
public abstract class VectorScalarOperation
implements RosettaFunction {
    @Inject
    protected ArithmeticOperation arithmeticOperation;

    public List<BigDecimal> evaluate(ArithmeticOperationEnum arithmeticOp, List<BigDecimal> left, BigDecimal right) {
        List<BigDecimal> result = this.doEvaluate(arithmeticOp, left, right);
        return result;
    }

    protected abstract List<BigDecimal> doEvaluate(ArithmeticOperationEnum var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract MapperS<BigDecimal> rightOrDefault(ArithmeticOperationEnum var1, List<BigDecimal> var2, BigDecimal var3);

    public static class VectorScalarOperationDefault
    extends VectorScalarOperation {
        @Override
        protected List<BigDecimal> doEvaluate(ArithmeticOperationEnum arithmeticOp, List<BigDecimal> left, BigDecimal right) {
            if (left == null) {
                left = Collections.emptyList();
            }
            ArrayList<BigDecimal> result = new ArrayList<BigDecimal>();
            return this.assignOutput(result, arithmeticOp, left, right);
        }

        protected List<BigDecimal> assignOutput(List<BigDecimal> result, ArithmeticOperationEnum arithmeticOp, List<BigDecimal> left, BigDecimal right) {
            result.addAll(MapperC.of(left).mapItem(item -> MapperS.of((Object)this.arithmeticOperation.evaluate((BigDecimal)item.get(), arithmeticOp, (BigDecimal)this.rightOrDefault(arithmeticOp, left, right).get()))).getMulti());
            return result;
        }

        @Override
        protected MapperS<BigDecimal> rightOrDefault(ArithmeticOperationEnum arithmeticOp, List<BigDecimal> left, BigDecimal right) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)right)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)right);
            }
            return MapperS.of((Object)new BigDecimal("0.0"));
        }
    }
}

