/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.Taxonomy;
import cdm.base.staticdata.asset.common.functions.DifferentOrdinalsCondition;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="TaxonomyDifferentOrdinals")
@ImplementedBy(value=Default.class)
public interface TaxonomyDifferentOrdinals
extends Validator<Taxonomy> {
    public static final String NAME = "TaxonomyDifferentOrdinals";
    public static final String DEFINITION = "if value -> classification -> ordinal exists then DifferentOrdinalsCondition";

    public static class NoOp
    implements TaxonomyDifferentOrdinals {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Taxonomy taxonomy) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TaxonomyDifferentOrdinals {
        @Inject
        protected DifferentOrdinalsCondition differentOrdinalsCondition;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Taxonomy taxonomy) {
            ComparisonResult result = this.executeDataRule(taxonomy);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TaxonomyDifferentOrdinals.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Taxonomy", (RosettaPath)path, (String)TaxonomyDifferentOrdinals.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TaxonomyDifferentOrdinals.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Taxonomy", (RosettaPath)path, (String)TaxonomyDifferentOrdinals.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Taxonomy taxonomy) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)taxonomy).map("getValue", _taxonomy -> _taxonomy.getValue()).mapC("getClassification", taxonomyValue -> taxonomyValue.getClassification()).map("getOrdinal", taxonomyClassification -> taxonomyClassification.getOrdinal())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.differentOrdinalsCondition.evaluate(taxonomy)));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

