/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.identifier.validation.datarule;

import cdm.base.staticdata.identifier.Identifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="IdentifierIssuerChoice")
@ImplementedBy(value=Default.class)
public interface IdentifierIssuerChoice
extends Validator<Identifier> {
    public static final String NAME = "IdentifierIssuerChoice";
    public static final String DEFINITION = "required choice issuerReference, issuer";

    public static class NoOp
    implements IdentifierIssuerChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Identifier identifier) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements IdentifierIssuerChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Identifier identifier) {
            ComparisonResult result = this.executeDataRule(identifier);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)IdentifierIssuerChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Identifier", (RosettaPath)path, (String)IdentifierIssuerChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)IdentifierIssuerChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Identifier", (RosettaPath)path, (String)IdentifierIssuerChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Identifier identifier) {
            try {
                return ExpressionOperatorsNullSafe.choice((Mapper)MapperS.of((Object)identifier), Arrays.asList("issuerReference", "issuer"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

