/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="CallTypeEnum")
public enum CallTypeEnum {
    MARGIN_CALL("MarginCall", null),
    NOTIFICATION("Notification", null),
    EXPECTED_CALL("ExpectedCall", null);

    private static Map<String, CallTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private CallTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static CallTypeEnum fromDisplayName(String name) {
        CallTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, CallTypeEnum> map = new ConcurrentHashMap<String, CallTypeEnum>();
        for (CallTypeEnum instance : CallTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

