/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.ObservationEvent;
import cdm.event.common.State;
import cdm.event.common.Valuation;
import cdm.event.common.meta.CounterpartyPositionStateMeta;
import cdm.event.position.CounterpartyPosition;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CounterpartyPositionState", builder=CounterpartyPositionStateBuilderImpl.class, version="5.31.0")
@RuneDataType(value="CounterpartyPositionState", model="cdm", builder=CounterpartyPositionStateBuilderImpl.class, version="5.31.0")
public interface CounterpartyPositionState
extends RosettaModelObject,
GlobalKey {
    public static final CounterpartyPositionStateMeta metaData = new CounterpartyPositionStateMeta();

    public CounterpartyPosition getCounterpartyPosition();

    public State getState();

    public List<? extends ObservationEvent> getObservationHistory();

    public List<? extends Valuation> getValuationHistory();

    public MetaFields getMeta();

    public CounterpartyPositionState build();

    public CounterpartyPositionStateBuilder toBuilder();

    public static CounterpartyPositionStateBuilder builder() {
        return new CounterpartyPositionStateBuilderImpl();
    }

    default public RosettaMetaData<? extends CounterpartyPositionState> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CounterpartyPositionState> getType() {
        return CounterpartyPositionState.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("counterpartyPosition"), processor, CounterpartyPosition.class, this.getCounterpartyPosition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("state"), processor, State.class, this.getState(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationHistory"), processor, ObservationEvent.class, this.getObservationHistory(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationHistory"), processor, Valuation.class, this.getValuationHistory(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class CounterpartyPositionStateBuilderImpl
    implements CounterpartyPositionStateBuilder {
        protected CounterpartyPosition.CounterpartyPositionBuilder counterpartyPosition;
        protected State.StateBuilder state;
        protected List<ObservationEvent.ObservationEventBuilder> observationHistory = new ArrayList<ObservationEvent.ObservationEventBuilder>();
        protected List<Valuation.ValuationBuilder> valuationHistory = new ArrayList<Valuation.ValuationBuilder>();
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="counterpartyPosition", isRequired=true)
        @RuneAttribute(value="counterpartyPosition", isRequired=true)
        public CounterpartyPosition.CounterpartyPositionBuilder getCounterpartyPosition() {
            return this.counterpartyPosition;
        }

        @Override
        public CounterpartyPosition.CounterpartyPositionBuilder getOrCreateCounterpartyPosition() {
            CounterpartyPosition.CounterpartyPositionBuilder result = this.counterpartyPosition != null ? this.counterpartyPosition : (this.counterpartyPosition = CounterpartyPosition.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="state")
        @RuneAttribute(value="state")
        public State.StateBuilder getState() {
            return this.state;
        }

        @Override
        public State.StateBuilder getOrCreateState() {
            State.StateBuilder result = this.state != null ? this.state : (this.state = State.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="observationHistory")
        @RuneAttribute(value="observationHistory")
        public List<? extends ObservationEvent.ObservationEventBuilder> getObservationHistory() {
            return this.observationHistory;
        }

        @Override
        public ObservationEvent.ObservationEventBuilder getOrCreateObservationHistory(int index) {
            if (this.observationHistory == null) {
                this.observationHistory = new ArrayList<ObservationEvent.ObservationEventBuilder>();
            }
            return (ObservationEvent.ObservationEventBuilder)this.getIndex(this.observationHistory, index, () -> {
                ObservationEvent.ObservationEventBuilder newObservationHistory = ObservationEvent.builder();
                return newObservationHistory;
            });
        }

        @Override
        @RosettaAttribute(value="valuationHistory")
        @RuneAttribute(value="valuationHistory")
        public List<? extends Valuation.ValuationBuilder> getValuationHistory() {
            return this.valuationHistory;
        }

        @Override
        public Valuation.ValuationBuilder getOrCreateValuationHistory(int index) {
            if (this.valuationHistory == null) {
                this.valuationHistory = new ArrayList<Valuation.ValuationBuilder>();
            }
            return (Valuation.ValuationBuilder)this.getIndex(this.valuationHistory, index, () -> {
                Valuation.ValuationBuilder newValuationHistory = Valuation.builder();
                return newValuationHistory;
            });
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="counterpartyPosition", isRequired=true)
        @RuneAttribute(value="counterpartyPosition", isRequired=true)
        public CounterpartyPositionStateBuilder setCounterpartyPosition(CounterpartyPosition _counterpartyPosition) {
            this.counterpartyPosition = _counterpartyPosition == null ? null : _counterpartyPosition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="state")
        @RuneAttribute(value="state")
        public CounterpartyPositionStateBuilder setState(State _state) {
            this.state = _state == null ? null : _state.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observationHistory")
        @RuneAttribute(value="observationHistory")
        public CounterpartyPositionStateBuilder addObservationHistory(ObservationEvent _observationHistory) {
            if (_observationHistory != null) {
                this.observationHistory.add(_observationHistory.toBuilder());
            }
            return this;
        }

        @Override
        public CounterpartyPositionStateBuilder addObservationHistory(ObservationEvent _observationHistory, int idx) {
            this.getIndex(this.observationHistory, idx, () -> _observationHistory.toBuilder());
            return this;
        }

        @Override
        public CounterpartyPositionStateBuilder addObservationHistory(List<? extends ObservationEvent> observationHistorys) {
            if (observationHistorys != null) {
                for (ObservationEvent observationEvent : observationHistorys) {
                    this.observationHistory.add(observationEvent.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="observationHistory")
        public CounterpartyPositionStateBuilder setObservationHistory(List<? extends ObservationEvent> observationHistorys) {
            this.observationHistory = observationHistorys == null ? new ArrayList<ObservationEvent.ObservationEventBuilder>() : (List)observationHistorys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationHistory")
        @RuneAttribute(value="valuationHistory")
        public CounterpartyPositionStateBuilder addValuationHistory(Valuation _valuationHistory) {
            if (_valuationHistory != null) {
                this.valuationHistory.add(_valuationHistory.toBuilder());
            }
            return this;
        }

        @Override
        public CounterpartyPositionStateBuilder addValuationHistory(Valuation _valuationHistory, int idx) {
            this.getIndex(this.valuationHistory, idx, () -> _valuationHistory.toBuilder());
            return this;
        }

        @Override
        public CounterpartyPositionStateBuilder addValuationHistory(List<? extends Valuation> valuationHistorys) {
            if (valuationHistorys != null) {
                for (Valuation valuation : valuationHistorys) {
                    this.valuationHistory.add(valuation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="valuationHistory")
        public CounterpartyPositionStateBuilder setValuationHistory(List<? extends Valuation> valuationHistorys) {
            this.valuationHistory = valuationHistorys == null ? new ArrayList<Valuation.ValuationBuilder>() : (List)valuationHistorys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public CounterpartyPositionStateBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public CounterpartyPositionState build() {
            return new CounterpartyPositionStateImpl(this);
        }

        @Override
        public CounterpartyPositionStateBuilder toBuilder() {
            return this;
        }

        @Override
        public CounterpartyPositionStateBuilder prune() {
            if (this.counterpartyPosition != null && !this.counterpartyPosition.prune().hasData()) {
                this.counterpartyPosition = null;
            }
            if (this.state != null && !this.state.prune().hasData()) {
                this.state = null;
            }
            this.observationHistory = this.observationHistory.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.valuationHistory = this.valuationHistory.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCounterpartyPosition() != null && this.getCounterpartyPosition().hasData()) {
                return true;
            }
            if (this.getState() != null && this.getState().hasData()) {
                return true;
            }
            if (this.getObservationHistory() != null && this.getObservationHistory().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getValuationHistory() != null && this.getValuationHistory().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public CounterpartyPositionStateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CounterpartyPositionStateBuilder o = (CounterpartyPositionStateBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCounterpartyPosition(), (RosettaModelObjectBuilder)o.getCounterpartyPosition(), this::setCounterpartyPosition);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getState(), (RosettaModelObjectBuilder)o.getState(), this::setState);
            merger.mergeRosetta(this.getObservationHistory(), o.getObservationHistory(), this::getOrCreateObservationHistory);
            merger.mergeRosetta(this.getValuationHistory(), o.getValuationHistory(), this::getOrCreateValuationHistory);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CounterpartyPositionState _that = this.getType().cast(o);
            if (!Objects.equals(this.counterpartyPosition, _that.getCounterpartyPosition())) {
                return false;
            }
            if (!Objects.equals(this.state, _that.getState())) {
                return false;
            }
            if (!ListEquals.listEquals(this.observationHistory, _that.getObservationHistory())) {
                return false;
            }
            if (!ListEquals.listEquals(this.valuationHistory, _that.getValuationHistory())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.counterpartyPosition != null ? this.counterpartyPosition.hashCode() : 0);
            _result = 31 * _result + (this.state != null ? this.state.hashCode() : 0);
            _result = 31 * _result + (this.observationHistory != null ? this.observationHistory.hashCode() : 0);
            _result = 31 * _result + (this.valuationHistory != null ? this.valuationHistory.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CounterpartyPositionStateBuilder {counterpartyPosition=" + this.counterpartyPosition + ", state=" + this.state + ", observationHistory=" + this.observationHistory + ", valuationHistory=" + this.valuationHistory + ", meta=" + this.meta + '}';
        }
    }

    public static interface CounterpartyPositionStateBuilder
    extends CounterpartyPositionState,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public CounterpartyPosition.CounterpartyPositionBuilder getOrCreateCounterpartyPosition();

        @Override
        public CounterpartyPosition.CounterpartyPositionBuilder getCounterpartyPosition();

        public State.StateBuilder getOrCreateState();

        @Override
        public State.StateBuilder getState();

        public ObservationEvent.ObservationEventBuilder getOrCreateObservationHistory(int var1);

        public List<? extends ObservationEvent.ObservationEventBuilder> getObservationHistory();

        public Valuation.ValuationBuilder getOrCreateValuationHistory(int var1);

        public List<? extends Valuation.ValuationBuilder> getValuationHistory();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public CounterpartyPositionStateBuilder setCounterpartyPosition(CounterpartyPosition var1);

        public CounterpartyPositionStateBuilder setState(State var1);

        public CounterpartyPositionStateBuilder addObservationHistory(ObservationEvent var1);

        public CounterpartyPositionStateBuilder addObservationHistory(ObservationEvent var1, int var2);

        public CounterpartyPositionStateBuilder addObservationHistory(List<? extends ObservationEvent> var1);

        public CounterpartyPositionStateBuilder setObservationHistory(List<? extends ObservationEvent> var1);

        public CounterpartyPositionStateBuilder addValuationHistory(Valuation var1);

        public CounterpartyPositionStateBuilder addValuationHistory(Valuation var1, int var2);

        public CounterpartyPositionStateBuilder addValuationHistory(List<? extends Valuation> var1);

        public CounterpartyPositionStateBuilder setValuationHistory(List<? extends Valuation> var1);

        public CounterpartyPositionStateBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("counterpartyPosition"), processor, CounterpartyPosition.CounterpartyPositionBuilder.class, this.getCounterpartyPosition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("state"), processor, State.StateBuilder.class, this.getState(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationHistory"), processor, ObservationEvent.ObservationEventBuilder.class, this.getObservationHistory(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationHistory"), processor, Valuation.ValuationBuilder.class, this.getValuationHistory(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public CounterpartyPositionStateBuilder prune();
    }

    public static class CounterpartyPositionStateImpl
    implements CounterpartyPositionState {
        private final CounterpartyPosition counterpartyPosition;
        private final State state;
        private final List<? extends ObservationEvent> observationHistory;
        private final List<? extends Valuation> valuationHistory;
        private final MetaFields meta;

        protected CounterpartyPositionStateImpl(CounterpartyPositionStateBuilder builder) {
            this.counterpartyPosition = Optional.ofNullable(builder.getCounterpartyPosition()).map(f -> f.build()).orElse(null);
            this.state = Optional.ofNullable(builder.getState()).map(f -> f.build()).orElse(null);
            this.observationHistory = Optional.ofNullable(builder.getObservationHistory()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.valuationHistory = Optional.ofNullable(builder.getValuationHistory()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="counterpartyPosition", isRequired=true)
        @RuneAttribute(value="counterpartyPosition", isRequired=true)
        public CounterpartyPosition getCounterpartyPosition() {
            return this.counterpartyPosition;
        }

        @Override
        @RosettaAttribute(value="state")
        @RuneAttribute(value="state")
        public State getState() {
            return this.state;
        }

        @Override
        @RosettaAttribute(value="observationHistory")
        @RuneAttribute(value="observationHistory")
        public List<? extends ObservationEvent> getObservationHistory() {
            return this.observationHistory;
        }

        @Override
        @RosettaAttribute(value="valuationHistory")
        @RuneAttribute(value="valuationHistory")
        public List<? extends Valuation> getValuationHistory() {
            return this.valuationHistory;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public CounterpartyPositionState build() {
            return this;
        }

        @Override
        public CounterpartyPositionStateBuilder toBuilder() {
            CounterpartyPositionStateBuilder builder = CounterpartyPositionState.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CounterpartyPositionStateBuilder builder) {
            Optional.ofNullable(this.getCounterpartyPosition()).ifPresent(builder::setCounterpartyPosition);
            Optional.ofNullable(this.getState()).ifPresent(builder::setState);
            Optional.ofNullable(this.getObservationHistory()).ifPresent(builder::setObservationHistory);
            Optional.ofNullable(this.getValuationHistory()).ifPresent(builder::setValuationHistory);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CounterpartyPositionState _that = this.getType().cast(o);
            if (!Objects.equals(this.counterpartyPosition, _that.getCounterpartyPosition())) {
                return false;
            }
            if (!Objects.equals(this.state, _that.getState())) {
                return false;
            }
            if (!ListEquals.listEquals(this.observationHistory, _that.getObservationHistory())) {
                return false;
            }
            if (!ListEquals.listEquals(this.valuationHistory, _that.getValuationHistory())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.counterpartyPosition != null ? this.counterpartyPosition.hashCode() : 0);
            _result = 31 * _result + (this.state != null ? this.state.hashCode() : 0);
            _result = 31 * _result + (this.observationHistory != null ? this.observationHistory.hashCode() : 0);
            _result = 31 * _result + (this.valuationHistory != null ? this.valuationHistory.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CounterpartyPositionState {counterpartyPosition=" + this.counterpartyPosition + ", state=" + this.state + ", observationHistory=" + this.observationHistory + ", valuationHistory=" + this.valuationHistory + ", meta=" + this.meta + '}';
        }
    }
}

