/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.ExecutionInstruction;
import cdm.event.common.ExerciseInstruction;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.TradeState;
import cdm.event.common.functions.Create_Execution;
import cdm.event.common.functions.Create_TradeState;
import cdm.product.template.OptionPayout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=Create_ExerciseDefault.class)
public abstract class Create_Exercise
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_Execution create_Execution;
    @Inject
    protected Create_TradeState create_TradeState;

    public List<? extends TradeState> evaluate(ExerciseInstruction exerciseInstruction, TradeState originalTrade) {
        List exercise;
        this.conditionValidator.validate(() -> ExpressionOperatorsNullSafe.exists(this.optionPayout(exerciseInstruction, originalTrade)), "Requires that the original contract contains an option payout.");
        List<TradeState.TradeStateBuilder> exerciseBuilder = this.doEvaluate(exerciseInstruction, originalTrade);
        if (exerciseBuilder == null) {
            exercise = null;
        } else {
            exercise = exerciseBuilder.stream().map(TradeState::build).collect(Collectors.toList());
            this.objectValidator.validate(TradeState.class, exercise);
        }
        return exercise;
    }

    protected abstract List<TradeState.TradeStateBuilder> doEvaluate(ExerciseInstruction var1, TradeState var2);

    protected abstract MapperS<? extends TradableProduct> tradableProduct(ExerciseInstruction var1, TradeState var2);

    protected abstract MapperS<? extends OptionPayout> optionPayout(ExerciseInstruction var1, TradeState var2);

    protected abstract MapperS<? extends Product> underlier(ExerciseInstruction var1, TradeState var2);

    protected abstract MapperS<? extends TradeState> execution(ExerciseInstruction var1, TradeState var2);

    public static class Create_ExerciseDefault
    extends Create_Exercise {
        @Override
        protected List<TradeState.TradeStateBuilder> doEvaluate(ExerciseInstruction exerciseInstruction, TradeState originalTrade) {
            ArrayList<TradeState.TradeStateBuilder> exercise = new ArrayList<TradeState.TradeStateBuilder>();
            return this.assignOutput(exercise, exerciseInstruction, originalTrade);
        }

        protected List<TradeState.TradeStateBuilder> assignOutput(List<TradeState.TradeStateBuilder> exercise, ExerciseInstruction exerciseInstruction, TradeState originalTrade) {
            TradeState tradeState = this.create_TradeState.evaluate((PrimitiveInstruction)MapperS.of((Object)exerciseInstruction).map("getExerciseQuantity", _exerciseInstruction -> _exerciseInstruction.getExerciseQuantity()).get(), originalTrade);
            if (tradeState == null) {
                exercise.addAll(this.toBuilder(Collections.emptyList()));
            } else {
                exercise.addAll(this.toBuilder(Collections.singletonList(tradeState)));
            }
            exercise.addAll(this.toBuilder(this.execution(exerciseInstruction, originalTrade).getMulti()));
            return Optional.ofNullable(exercise).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends TradableProduct> tradableProduct(ExerciseInstruction exerciseInstruction, TradeState originalTrade) {
            return MapperS.of((Object)originalTrade).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct());
        }

        @Override
        protected MapperS<? extends OptionPayout> optionPayout(ExerciseInstruction exerciseInstruction, TradeState originalTrade) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)exerciseInstruction).map("getExerciseOption", _exerciseInstruction -> _exerciseInstruction.getExerciseOption())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)exerciseInstruction).map("getExerciseOption", _exerciseInstruction -> _exerciseInstruction.getExerciseOption()).map("Type coercion", referenceWithMetaOptionPayout -> referenceWithMetaOptionPayout == null ? null : referenceWithMetaOptionPayout.getValue());
            }
            return MapperS.of((Object)((OptionPayout)this.tradableProduct(exerciseInstruction, originalTrade).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()));
        }

        @Override
        protected MapperS<? extends Product> underlier(ExerciseInstruction exerciseInstruction, TradeState originalTrade) {
            return this.optionPayout(exerciseInstruction, originalTrade).map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier());
        }

        @Override
        protected MapperS<? extends TradeState> execution(ExerciseInstruction exerciseInstruction, TradeState originalTrade) {
            return MapperS.of((Object)this.create_Execution.evaluate(ExecutionInstruction.builder().setProduct((Product)this.underlier(exerciseInstruction, originalTrade).get()).setPriceQuantity(MapperS.of((Object)((TradeLot)this.tradableProduct(exerciseInstruction, originalTrade).mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).getMulti()).setCounterparty(this.tradableProduct(exerciseInstruction, originalTrade).mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti()).setAncillaryParty(this.tradableProduct(exerciseInstruction, originalTrade).mapC("getAncillaryParty", _tradableProduct -> _tradableProduct.getAncillaryParty()).getMulti()).setParties(MapperS.of((Object)originalTrade).map("getTrade", tradeState -> tradeState.getTrade()).mapC("getParty", trade -> trade.getParty()).getMulti()).setPartyRoles(MapperS.of((Object)originalTrade).map("getTrade", tradeState -> tradeState.getTrade()).mapC("getPartyRole", trade -> trade.getPartyRole()).getMulti()).setExecutionDetails(null).setTradeDate((FieldWithMetaDate)MapperS.of((Object)originalTrade).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradeDate", trade -> trade.getTradeDate()).get()).setTradeIdentifier(MapperS.of((Object)exerciseInstruction).mapC("getReplacementTradeIdentifier", _exerciseInstruction -> _exerciseInstruction.getReplacementTradeIdentifier()).getMulti()).build()));
        }
    }
}

