/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TradePackageTrade")
@ImplementedBy(value=Default.class)
public interface TradePackageTrade
extends Validator<Trade> {
    public static final String NAME = "TradePackageTrade";
    public static final String DEFINITION = "if executionDetails -> packageReference exists then executionDetails -> packageReference -> componentId -> assignedIdentifier contains tradeIdentifier -> assignedIdentifier";

    public static class NoOp
    implements TradePackageTrade {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Trade trade) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TradePackageTrade {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Trade trade) {
            ComparisonResult result = this.executeDataRule(trade);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TradePackageTrade.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradePackageTrade.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TradePackageTrade.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradePackageTrade.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Trade trade) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getExecutionDetails", _trade -> _trade.getExecutionDetails()).map("getPackageReference", executionDetails -> executionDetails.getPackageReference())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.contains((Mapper)MapperS.of((Object)trade).map("getExecutionDetails", _trade -> _trade.getExecutionDetails()).map("getPackageReference", executionDetails -> executionDetails.getPackageReference()).mapC("getComponentId", identifiedList -> identifiedList.getComponentId()).mapC("getAssignedIdentifier", identifier -> identifier.getAssignedIdentifier()), (Mapper)MapperS.of((Object)trade).mapC("getTradeIdentifier", _trade -> _trade.getTradeIdentifier()).mapC("getAssignedIdentifier", tradeIdentifier -> tradeIdentifier.getAssignedIdentifier()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

