/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.Valuation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ValuationValuationType")
@ImplementedBy(value=Default.class)
public interface ValuationValuationType
extends Validator<Valuation> {
    public static final String NAME = "ValuationValuationType";
    public static final String DEFINITION = "required choice method, source";

    public static class NoOp
    implements ValuationValuationType {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Valuation valuation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ValuationValuationType {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Valuation valuation) {
            ComparisonResult result = this.executeDataRule(valuation);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ValuationValuationType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Valuation", (RosettaPath)path, (String)ValuationValuationType.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ValuationValuationType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Valuation", (RosettaPath)path, (String)ValuationValuationType.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Valuation valuation) {
            try {
                return ExpressionOperatorsNullSafe.choice((Mapper)MapperS.of((Object)valuation), Arrays.asList("method", "source"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

