/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.workflow.validation.datarule;

import cdm.event.common.EventIntentEnum;
import cdm.event.workflow.EventInstruction;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="EventInstructionCorporateAction")
@ImplementedBy(value=Default.class)
public interface EventInstructionCorporateAction
extends Validator<EventInstruction> {
    public static final String NAME = "EventInstructionCorporateAction";
    public static final String DEFINITION = "if corporateActionIntent exists then intent = EventIntentEnum -> CorporateActionAdjustment";

    public static class NoOp
    implements EventInstructionCorporateAction {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EventInstruction eventInstruction) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements EventInstructionCorporateAction {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EventInstruction eventInstruction) {
            ComparisonResult result = this.executeDataRule(eventInstruction);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)EventInstructionCorporateAction.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EventInstruction", (RosettaPath)path, (String)EventInstructionCorporateAction.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)EventInstructionCorporateAction.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EventInstruction", (RosettaPath)path, (String)EventInstructionCorporateAction.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(EventInstruction eventInstruction) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)eventInstruction).map("getCorporateActionIntent", _eventInstruction -> _eventInstruction.getCorporateActionIntent())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)eventInstruction).map("getIntent", _eventInstruction -> _eventInstruction.getIntent()), (Mapper)MapperS.of((Object)((Object)EventIntentEnum.CORPORATE_ACTION_ADJUSTMENT)), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

