/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common.validation.datarule;

import cdm.legaldocumentation.common.LegalAgreement;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="LegalAgreementConsistentlyExecutedAgreements")
@ImplementedBy(value=Default.class)
public interface LegalAgreementConsistentlyExecutedAgreements
extends Validator<LegalAgreement> {
    public static final String NAME = "LegalAgreementConsistentlyExecutedAgreements";
    public static final String DEFINITION = "if relatedAgreements exists and agreementDate exists then relatedAgreements -> agreementDate exists";

    public static class NoOp
    implements LegalAgreementConsistentlyExecutedAgreements {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LegalAgreement legalAgreement) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements LegalAgreementConsistentlyExecutedAgreements {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LegalAgreement legalAgreement) {
            ComparisonResult result = this.executeDataRule(legalAgreement);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)LegalAgreementConsistentlyExecutedAgreements.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegalAgreement", (RosettaPath)path, (String)LegalAgreementConsistentlyExecutedAgreements.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)LegalAgreementConsistentlyExecutedAgreements.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegalAgreement", (RosettaPath)path, (String)LegalAgreementConsistentlyExecutedAgreements.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(LegalAgreement legalAgreement) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)legalAgreement).mapC("getRelatedAgreements", _legalAgreement -> _legalAgreement.getRelatedAgreements())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)legalAgreement).map("getAgreementDate", _legalAgreement -> _legalAgreement.getAgreementDate()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)legalAgreement).mapC("getRelatedAgreements", _legalAgreement -> _legalAgreement.getRelatedAgreements()).map("getAgreementDate", _legalAgreement -> _legalAgreement.getAgreementDate()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

