/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.base.datetime.daycount.functions.YearFractionForOneDay;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.calculatedrate.CalculatedRateDetails;
import cdm.observable.asset.calculatedrate.CalculatedRateObservationDatesAndWeights;
import cdm.observable.asset.calculatedrate.CalculationMethodEnum;
import cdm.observable.asset.calculatedrate.FloatingRateCalculationParameters;
import cdm.observable.asset.calculatedrate.functions.ApplyAveragingFormula;
import cdm.observable.asset.calculatedrate.functions.ApplyCompoundingFormula;
import cdm.observable.asset.calculatedrate.functions.GenerateObservationDatesAndWeights;
import cdm.observable.asset.calculatedrate.functions.ProcessObservations;
import cdm.observable.asset.fro.functions.IndexValueObservationMultiple;
import cdm.product.asset.floatingrate.FloatingRateSettingDetails;
import cdm.product.common.schedule.CalculationPeriodBase;
import cdm.product.common.schedule.ResetDates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=EvaluateCalculatedRateDefault.class)
public abstract class EvaluateCalculatedRate
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ApplyAveragingFormula applyAveragingFormula;
    @Inject
    protected ApplyCompoundingFormula applyCompoundingFormula;
    @Inject
    protected GenerateObservationDatesAndWeights generateObservationDatesAndWeights;
    @Inject
    protected IndexValueObservationMultiple indexValueObservationMultiple;
    @Inject
    protected ProcessObservations processObservations;
    @Inject
    protected YearFractionForOneDay yearFractionForOneDay;

    public FloatingRateSettingDetails evaluate(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
        FloatingRateSettingDetails results;
        FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder resultsBuilder = this.doEvaluate(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount);
        if (resultsBuilder == null) {
            results = null;
        } else {
            results = resultsBuilder.build();
            this.objectValidator.validate(FloatingRateSettingDetails.class, (RosettaModelObject)results);
        }
        return results;
    }

    protected abstract FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperS<? extends FloatingRateOption> fro(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperS<? extends CalculatedRateObservationDatesAndWeights> datesAndWeights(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperC<Date> observationDates(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperC<BigDecimal> observations(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperC<BigDecimal> processedObservations(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperS<CalculationMethodEnum> calculationMethod(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperS<Boolean> isCompounding(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperC<BigDecimal> weights(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperS<BigDecimal> yearFraction(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract MapperS<? extends CalculatedRateDetails> calculationResults(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    public static class EvaluateCalculatedRateDefault
    extends EvaluateCalculatedRate {
        @Override
        protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder results = FloatingRateSettingDetails.builder();
            return this.assignOutput(results, floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount);
        }

        protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder assignOutput(FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder results, FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            results.setCalculationDetails((CalculatedRateDetails)this.calculationResults(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).get());
            results.getOrCreateCalculationDetails().getOrCreateObservations().addObservationDates(this.datesAndWeights(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).mapC("getObservationDates", calculatedRateObservationDatesAndWeights -> calculatedRateObservationDatesAndWeights.getObservationDates()).getMulti());
            results.getOrCreateCalculationDetails().getOrCreateObservations().addWeights(this.datesAndWeights(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).mapC("getWeights", calculatedRateObservationDatesAndWeights -> calculatedRateObservationDatesAndWeights.getWeights()).getMulti());
            results.getOrCreateCalculationDetails().getOrCreateObservations().addObservedRates(this.observations(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti());
            results.getOrCreateCalculationDetails().getOrCreateObservations().addProcessedRates(this.processedObservations(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti());
            results.setFloatingRate((BigDecimal)this.calculationResults(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).map("getCalculatedRate", calculatedRateDetails -> calculatedRateDetails.getCalculatedRate()).get());
            return Optional.ofNullable(results).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends FloatingRateOption> fro(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperS.of((Object)floatingRateOption);
        }

        @Override
        protected MapperS<? extends CalculatedRateObservationDatesAndWeights> datesAndWeights(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperS.of((Object)this.generateObservationDatesAndWeights.evaluate(calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod));
        }

        @Override
        protected MapperC<Date> observationDates(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return this.datesAndWeights(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).mapC("getObservationDates", calculatedRateObservationDatesAndWeights -> calculatedRateObservationDatesAndWeights.getObservationDates());
        }

        @Override
        protected MapperC<BigDecimal> observations(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperC.of(this.indexValueObservationMultiple.evaluate(this.observationDates(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti(), (FloatingRateOption)this.fro(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).get()));
        }

        @Override
        protected MapperC<BigDecimal> processedObservations(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperC.of(this.processObservations.evaluate(calculationParameters, this.observations(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti()));
        }

        @Override
        protected MapperS<CalculationMethodEnum> calculationMethod(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperS.of((Object)calculationParameters).map("getCalculationMethod", floatingRateCalculationParameters -> floatingRateCalculationParameters.getCalculationMethod());
        }

        @Override
        protected MapperS<Boolean> isCompounding(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return ExpressionOperatorsNullSafe.areEqual(this.calculationMethod(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount), (Mapper)MapperS.of((Object)((Object)CalculationMethodEnum.COMPOUNDING)), (CardinalityOperator)CardinalityOperator.All).asMapper();
        }

        @Override
        protected MapperC<BigDecimal> weights(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return this.datesAndWeights(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).mapC("getWeights", calculatedRateObservationDatesAndWeights -> calculatedRateObservationDatesAndWeights.getWeights());
        }

        @Override
        protected MapperS<BigDecimal> yearFraction(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperS.of((Object)this.yearFractionForOneDay.evaluate(dayCount));
        }

        @Override
        protected MapperS<? extends CalculatedRateDetails> calculationResults(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            if (((Boolean)this.isCompounding(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getOrDefault((Object)false)).booleanValue()) {
                return MapperS.of((Object)this.applyCompoundingFormula.evaluate(this.processedObservations(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti(), this.weights(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti(), (BigDecimal)this.yearFraction(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).get()));
            }
            return MapperS.of((Object)this.applyAveragingFormula.evaluate(this.observations(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti(), this.weights(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti()));
        }
    }
}

