/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.BusinessCenters;
import cdm.base.datetime.functions.GetAllBusinessCenters;
import cdm.observable.asset.calculatedrate.CalculatedRateObservationDatesAndWeights;
import cdm.observable.asset.calculatedrate.FloatingRateCalculationParameters;
import cdm.observable.asset.calculatedrate.ObservationPeriodDatesEnum;
import cdm.observable.asset.calculatedrate.ObservationShiftCalculation;
import cdm.observable.asset.calculatedrate.OffsetCalculation;
import cdm.observable.asset.calculatedrate.functions.ComputeCalculationPeriod;
import cdm.observable.asset.calculatedrate.functions.DetermineObservationPeriod;
import cdm.observable.asset.calculatedrate.functions.GenerateObservationDates;
import cdm.observable.asset.calculatedrate.functions.GenerateWeightings;
import cdm.product.common.schedule.CalculationPeriodBase;
import cdm.product.common.schedule.ResetDates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GenerateObservationDatesAndWeightsDefault.class)
public abstract class GenerateObservationDatesAndWeights
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ComputeCalculationPeriod computeCalculationPeriod;
    @Inject
    protected DetermineObservationPeriod determineObservationPeriod;
    @Inject
    protected GenerateObservationDates generateObservationDates;
    @Inject
    protected GenerateWeightings generateWeightings;
    @Inject
    protected GetAllBusinessCenters getAllBusinessCenters;

    public CalculatedRateObservationDatesAndWeights evaluate(FloatingRateCalculationParameters calculationParams, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod) {
        CalculatedRateObservationDatesAndWeights results;
        CalculatedRateObservationDatesAndWeights.CalculatedRateObservationDatesAndWeightsBuilder resultsBuilder = this.doEvaluate(calculationParams, resetDates, calculationPeriod, priorCalculationPeriod);
        if (resultsBuilder == null) {
            results = null;
        } else {
            results = resultsBuilder.build();
            this.objectValidator.validate(CalculatedRateObservationDatesAndWeights.class, (RosettaModelObject)results);
        }
        return results;
    }

    protected abstract CalculatedRateObservationDatesAndWeights.CalculatedRateObservationDatesAndWeightsBuilder doEvaluate(FloatingRateCalculationParameters var1, ResetDates var2, CalculationPeriodBase var3, CalculationPeriodBase var4);

    protected abstract MapperS<? extends ObservationShiftCalculation> obsShift(FloatingRateCalculationParameters var1, ResetDates var2, CalculationPeriodBase var3, CalculationPeriodBase var4);

    protected abstract MapperS<? extends OffsetCalculation> lockout(FloatingRateCalculationParameters var1, ResetDates var2, CalculationPeriodBase var3, CalculationPeriodBase var4);

    protected abstract MapperS<Integer> specifiedLockout(FloatingRateCalculationParameters var1, ResetDates var2, CalculationPeriodBase var3, CalculationPeriodBase var4);

    protected abstract MapperS<Integer> lockoutDays(FloatingRateCalculationParameters var1, ResetDates var2, CalculationPeriodBase var3, CalculationPeriodBase var4);

    protected abstract MapperC<BusinessCenterEnum> businessDays(FloatingRateCalculationParameters var1, ResetDates var2, CalculationPeriodBase var3, CalculationPeriodBase var4);

    protected abstract MapperS<ObservationPeriodDatesEnum> calculateRelative(FloatingRateCalculationParameters var1, ResetDates var2, CalculationPeriodBase var3, CalculationPeriodBase var4);

    protected abstract MapperS<? extends CalculationPeriodBase> adjustedCalculationPeriod(FloatingRateCalculationParameters var1, ResetDates var2, CalculationPeriodBase var3, CalculationPeriodBase var4);

    protected abstract MapperS<? extends CalculationPeriodBase> observationPeriod(FloatingRateCalculationParameters var1, ResetDates var2, CalculationPeriodBase var3, CalculationPeriodBase var4);

    protected abstract MapperC<Date> observationDates(FloatingRateCalculationParameters var1, ResetDates var2, CalculationPeriodBase var3, CalculationPeriodBase var4);

    public static class GenerateObservationDatesAndWeightsDefault
    extends GenerateObservationDatesAndWeights {
        @Override
        protected CalculatedRateObservationDatesAndWeights.CalculatedRateObservationDatesAndWeightsBuilder doEvaluate(FloatingRateCalculationParameters calculationParams, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod) {
            CalculatedRateObservationDatesAndWeights.CalculatedRateObservationDatesAndWeightsBuilder results = CalculatedRateObservationDatesAndWeights.builder();
            return this.assignOutput(results, calculationParams, resetDates, calculationPeriod, priorCalculationPeriod);
        }

        protected CalculatedRateObservationDatesAndWeights.CalculatedRateObservationDatesAndWeightsBuilder assignOutput(CalculatedRateObservationDatesAndWeights.CalculatedRateObservationDatesAndWeightsBuilder results, FloatingRateCalculationParameters calculationParams, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod) {
            results.addObservationDates(this.observationDates(calculationParams, resetDates, calculationPeriod, priorCalculationPeriod).getMulti());
            results.addWeights(this.generateWeightings.evaluate(calculationParams, MapperS.of((Object)results).mapC("getObservationDates", calculatedRateObservationDatesAndWeights -> calculatedRateObservationDatesAndWeights.getObservationDates()).getMulti(), (CalculationPeriodBase)this.observationPeriod(calculationParams, resetDates, calculationPeriod, priorCalculationPeriod).get(), (CalculationPeriodBase)this.adjustedCalculationPeriod(calculationParams, resetDates, calculationPeriod, priorCalculationPeriod).get(), (Integer)this.lockoutDays(calculationParams, resetDates, calculationPeriod, priorCalculationPeriod).get()));
            return Optional.ofNullable(results).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends ObservationShiftCalculation> obsShift(FloatingRateCalculationParameters calculationParams, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod) {
            return MapperS.of((Object)calculationParams).map("getObservationShiftCalculation", floatingRateCalculationParameters -> floatingRateCalculationParameters.getObservationShiftCalculation());
        }

        @Override
        protected MapperS<? extends OffsetCalculation> lockout(FloatingRateCalculationParameters calculationParams, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod) {
            return MapperS.of((Object)calculationParams).map("getLockoutCalculation", floatingRateCalculationParameters -> floatingRateCalculationParameters.getLockoutCalculation());
        }

        @Override
        protected MapperS<Integer> specifiedLockout(FloatingRateCalculationParameters calculationParams, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)this.lockout(calculationParams, resetDates, calculationPeriod, priorCalculationPeriod).map("getOffsetDays", offsetCalculation -> offsetCalculation.getOffsetDays())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.lockout(calculationParams, resetDates, calculationPeriod, priorCalculationPeriod).map("getOffsetDays", offsetCalculation -> offsetCalculation.getOffsetDays());
            }
            return MapperS.of((Object)5);
        }

        @Override
        protected MapperS<Integer> lockoutDays(FloatingRateCalculationParameters calculationParams, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod) {
            if (ExpressionOperatorsNullSafe.exists(this.lockout(calculationParams, resetDates, calculationPeriod, priorCalculationPeriod)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.specifiedLockout(calculationParams, resetDates, calculationPeriod, priorCalculationPeriod);
            }
            return MapperS.of((Object)0);
        }

        @Override
        protected MapperC<BusinessCenterEnum> businessDays(FloatingRateCalculationParameters calculationParams, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod) {
            return MapperC.of(this.getAllBusinessCenters.evaluate((BusinessCenters)MapperS.of((Object)calculationParams).map("getApplicableBusinessDays", floatingRateCalculationParameters -> floatingRateCalculationParameters.getApplicableBusinessDays()).get()));
        }

        @Override
        protected MapperS<ObservationPeriodDatesEnum> calculateRelative(FloatingRateCalculationParameters calculationParams, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)this.obsShift(calculationParams, resetDates, calculationPeriod, priorCalculationPeriod).map("getCalculationBase", observationShiftCalculation -> observationShiftCalculation.getCalculationBase())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.obsShift(calculationParams, resetDates, calculationPeriod, priorCalculationPeriod).map("getCalculationBase", observationShiftCalculation -> observationShiftCalculation.getCalculationBase());
            }
            return MapperS.of((Object)((Object)ObservationPeriodDatesEnum.STANDARD));
        }

        @Override
        protected MapperS<? extends CalculationPeriodBase> adjustedCalculationPeriod(FloatingRateCalculationParameters calculationParams, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod) {
            return MapperS.of((Object)this.computeCalculationPeriod.evaluate(calculationPeriod, priorCalculationPeriod, (ObservationPeriodDatesEnum)((Object)this.calculateRelative(calculationParams, resetDates, calculationPeriod, priorCalculationPeriod).get()), resetDates));
        }

        @Override
        protected MapperS<? extends CalculationPeriodBase> observationPeriod(FloatingRateCalculationParameters calculationParams, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod) {
            return MapperS.of((Object)this.determineObservationPeriod.evaluate((CalculationPeriodBase)this.adjustedCalculationPeriod(calculationParams, resetDates, calculationPeriod, priorCalculationPeriod).get(), calculationParams));
        }

        @Override
        protected MapperC<Date> observationDates(FloatingRateCalculationParameters calculationParams, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod) {
            return MapperC.of(this.generateObservationDates.evaluate((CalculationPeriodBase)this.observationPeriod(calculationParams, resetDates, calculationPeriod, priorCalculationPeriod).get(), this.businessDays(calculationParams, resetDates, calculationPeriod, priorCalculationPeriod).getMulti(), (Integer)this.lockoutDays(calculationParams, resetDates, calculationPeriod, priorCalculationPeriod).get()));
        }
    }
}

