/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PriceSchedulePositiveCashPrice")
@ImplementedBy(value=Default.class)
public interface PriceSchedulePositiveCashPrice
extends Validator<PriceSchedule> {
    public static final String NAME = "PriceSchedulePositiveCashPrice";
    public static final String DEFINITION = "if priceType = PriceTypeEnum -> CashPrice then value >= 0 or datedValue -> value all >= 0";

    public static class NoOp
    implements PriceSchedulePositiveCashPrice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceSchedule priceSchedule) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PriceSchedulePositiveCashPrice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceSchedule priceSchedule) {
            ComparisonResult result = this.executeDataRule(priceSchedule);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PriceSchedulePositiveCashPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceSchedulePositiveCashPrice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PriceSchedulePositiveCashPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceSchedulePositiveCashPrice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PriceSchedule priceSchedule) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)priceSchedule).map("getPriceType", _priceSchedule -> _priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.CASH_PRICE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.greaterThanEquals((Mapper)MapperS.of((Object)priceSchedule).map("getValue", _priceSchedule -> _priceSchedule.getValue()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.greaterThanEquals((Mapper)MapperS.of((Object)priceSchedule).mapC("getDatedValue", _priceSchedule -> _priceSchedule.getDatedValue()).map("getValue", datedValue -> datedValue.getValue()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

