/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate.functions;

import cdm.base.math.functions.Max;
import cdm.product.asset.NegativeInterestRateTreatmentEnum;
import cdm.product.asset.RateTreatmentEnum;
import cdm.product.asset.floatingrate.FloatingRateProcessingDetails;
import cdm.product.asset.floatingrate.FloatingRateProcessingParameters;
import cdm.product.asset.floatingrate.functions.ApplyFloatingRatePostSpreadProcessing;
import cdm.product.asset.floatingrate.functions.ApplyUSRateTreatment;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ApplyFloatingRateProcessingDefault.class)
public abstract class ApplyFloatingRateProcessing
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ApplyFloatingRatePostSpreadProcessing applyFloatingRatePostSpreadProcessing;
    @Inject
    protected ApplyUSRateTreatment applyUSRateTreatment;
    @Inject
    protected Max max;

    public FloatingRateProcessingDetails evaluate(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
        FloatingRateProcessingDetails details;
        FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder detailsBuilder = this.doEvaluate(processing, rawRate, calculationPeriod, isInitialPeriod);
        if (detailsBuilder == null) {
            details = null;
        } else {
            details = detailsBuilder.build();
            this.objectValidator.validate(FloatingRateProcessingDetails.class, (RosettaModelObject)details);
        }
        return details;
    }

    protected abstract FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder doEvaluate(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract MapperS<BigDecimal> multiplier(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract MapperS<BigDecimal> multiplied(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract MapperS<BigDecimal> multipliedRate(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract MapperS<BigDecimal> treatedRate(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract MapperS<NegativeInterestRateTreatmentEnum> negativeTreatment(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract MapperS<BigDecimal> negativeTreatedRate(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract MapperS<BigDecimal> spreadRate(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract MapperS<BigDecimal> added(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract MapperS<BigDecimal> ratePlusSpread(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract MapperS<BigDecimal> negativeTreatedRatePlusSpread(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract MapperS<Boolean> doInitialRate(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract MapperS<BigDecimal> initialRate(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract MapperS<BigDecimal> initialRatePluSpread(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract MapperS<BigDecimal> initialRatePlusSpread(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    public static class ApplyFloatingRateProcessingDefault
    extends ApplyFloatingRateProcessing {
        @Override
        protected FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder doEvaluate(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder details = FloatingRateProcessingDetails.builder();
            return this.assignOutput(details, processing, rawRate, calculationPeriod, isInitialPeriod);
        }

        protected FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder assignOutput(FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder details, FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            details.setProcessingParameters(processing);
            details.setRawRate(rawRate);
            BigDecimal ifThenElseResult0 = ExpressionOperatorsNullSafe.areEqual(this.doInitialRate(processing, rawRate, calculationPeriod, isInitialPeriod), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (BigDecimal)this.initialRatePluSpread(processing, rawRate, calculationPeriod, isInitialPeriod).get() : this.applyFloatingRatePostSpreadProcessing.evaluate((BigDecimal)this.ratePlusSpread(processing, rawRate, calculationPeriod, isInitialPeriod).get(), processing);
            details.setProcessedRate(ifThenElseResult0);
            BigDecimal ifThenElseResult1 = ExpressionOperatorsNullSafe.areEqual(this.doInitialRate(processing, rawRate, calculationPeriod, isInitialPeriod), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (BigDecimal)this.initialRate(processing, rawRate, calculationPeriod, isInitialPeriod).get() : this.applyFloatingRatePostSpreadProcessing.evaluate((BigDecimal)this.negativeTreatedRate(processing, rawRate, calculationPeriod, isInitialPeriod).get(), processing);
            details.setSpreadExclusiveRate(ifThenElseResult1);
            return Optional.ofNullable(details).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<BigDecimal> multiplier(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperS.of((Object)processing).map("getMultiplier", floatingRateProcessingParameters -> floatingRateProcessingParameters.getMultiplier());
        }

        @Override
        protected MapperS<BigDecimal> multiplied(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperMaths.multiply((Mapper)MapperS.of((Object)rawRate), this.multiplier(processing, rawRate, calculationPeriod, isInitialPeriod));
        }

        @Override
        protected MapperS<BigDecimal> multipliedRate(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            if (ExpressionOperatorsNullSafe.exists(this.multiplier(processing, rawRate, calculationPeriod, isInitialPeriod)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.multiplied(processing, rawRate, calculationPeriod, isInitialPeriod);
            }
            return MapperS.of((Object)rawRate);
        }

        @Override
        protected MapperS<BigDecimal> treatedRate(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperMaths.multiply((Mapper)MapperS.of((Object)this.applyUSRateTreatment.evaluate((BigDecimal)this.multipliedRate(processing, rawRate, calculationPeriod, isInitialPeriod).get(), (RateTreatmentEnum)((Object)MapperS.of((Object)processing).map("getTreatment", floatingRateProcessingParameters -> floatingRateProcessingParameters.getTreatment()).get()), calculationPeriod)), (Mapper)MapperS.of((Object)new BigDecimal("1.0")));
        }

        @Override
        protected MapperS<NegativeInterestRateTreatmentEnum> negativeTreatment(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperS.of((Object)processing).map("getNegativeTreatment", floatingRateProcessingParameters -> floatingRateProcessingParameters.getNegativeTreatment());
        }

        @Override
        protected MapperS<BigDecimal> negativeTreatedRate(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            if (ExpressionOperatorsNullSafe.areEqual(this.negativeTreatment(processing, rawRate, calculationPeriod, isInitialPeriod), (Mapper)MapperS.of((Object)((Object)NegativeInterestRateTreatmentEnum.ZERO_INTEREST_RATE_EXCLUDING_SPREAD_METHOD)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.max.evaluate(new BigDecimal("0.0"), (BigDecimal)this.treatedRate(processing, rawRate, calculationPeriod, isInitialPeriod).get()));
            }
            return this.treatedRate(processing, rawRate, calculationPeriod, isInitialPeriod);
        }

        @Override
        protected MapperS<BigDecimal> spreadRate(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperS.of((Object)processing).map("getSpread", floatingRateProcessingParameters -> floatingRateProcessingParameters.getSpread());
        }

        @Override
        protected MapperS<BigDecimal> added(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperMaths.add(this.negativeTreatedRate(processing, rawRate, calculationPeriod, isInitialPeriod), this.spreadRate(processing, rawRate, calculationPeriod, isInitialPeriod));
        }

        @Override
        protected MapperS<BigDecimal> ratePlusSpread(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            if (ExpressionOperatorsNullSafe.exists(this.spreadRate(processing, rawRate, calculationPeriod, isInitialPeriod)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.added(processing, rawRate, calculationPeriod, isInitialPeriod);
            }
            return this.negativeTreatedRate(processing, rawRate, calculationPeriod, isInitialPeriod);
        }

        @Override
        protected MapperS<BigDecimal> negativeTreatedRatePlusSpread(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            if (ExpressionOperatorsNullSafe.areEqual(this.negativeTreatment(processing, rawRate, calculationPeriod, isInitialPeriod), (Mapper)MapperS.of((Object)((Object)NegativeInterestRateTreatmentEnum.ZERO_INTEREST_RATE_METHOD)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.max.evaluate(new BigDecimal("0.0"), (BigDecimal)this.ratePlusSpread(processing, rawRate, calculationPeriod, isInitialPeriod).get()));
            }
            return this.ratePlusSpread(processing, rawRate, calculationPeriod, isInitialPeriod);
        }

        @Override
        protected MapperS<Boolean> doInitialRate(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)isInitialPeriod), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)processing).map("getInitialRate", floatingRateProcessingParameters -> floatingRateProcessingParameters.getInitialRate()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)true);
            }
            return MapperS.of((Object)false);
        }

        @Override
        protected MapperS<BigDecimal> initialRate(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperS.of((Object)processing).map("getInitialRate", floatingRateProcessingParameters -> floatingRateProcessingParameters.getInitialRate()).map("getValue", price -> price.getValue());
        }

        @Override
        protected MapperS<BigDecimal> initialRatePluSpread(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperMaths.add(this.initialRate(processing, rawRate, calculationPeriod, isInitialPeriod), this.spreadRate(processing, rawRate, calculationPeriod, isInitialPeriod));
        }

        @Override
        protected MapperS<BigDecimal> initialRatePlusSpread(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            if (ExpressionOperatorsNullSafe.exists(this.spreadRate(processing, rawRate, calculationPeriod, isInitialPeriod)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.initialRatePluSpread(processing, rawRate, calculationPeriod, isInitialPeriod);
            }
            return this.initialRate(processing, rawRate, calculationPeriod, isInitialPeriod);
        }
    }
}

