/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.CommodityPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CommodityPayoutQuantity")
@ImplementedBy(value=Default.class)
public interface CommodityPayoutQuantity
extends Validator<CommodityPayout> {
    public static final String NAME = "CommodityPayoutQuantity";
    public static final String DEFINITION = "priceQuantity exists";

    public static class NoOp
    implements CommodityPayoutQuantity {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CommodityPayout commodityPayout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CommodityPayoutQuantity {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CommodityPayout commodityPayout) {
            ComparisonResult result = this.executeDataRule(commodityPayout);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CommodityPayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CommodityPayout", (RosettaPath)path, (String)CommodityPayoutQuantity.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CommodityPayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CommodityPayout", (RosettaPath)path, (String)CommodityPayoutQuantity.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CommodityPayout commodityPayout) {
            try {
                return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)commodityPayout).map("getPriceQuantity", _commodityPayout -> _commodityPayout.getPriceQuantity()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

