/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral.validation.datarule;

import cdm.product.collateral.Collateral;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CollateralCollateralExists")
@ImplementedBy(value=Default.class)
public interface CollateralCollateralExists
extends Validator<Collateral> {
    public static final String NAME = "CollateralCollateralExists";
    public static final String DEFINITION = "independentAmount exists or collateralPortfolio exists";

    public static class NoOp
    implements CollateralCollateralExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Collateral collateral) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CollateralCollateralExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Collateral collateral) {
            ComparisonResult result = this.executeDataRule(collateral);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CollateralCollateralExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Collateral", (RosettaPath)path, (String)CollateralCollateralExists.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CollateralCollateralExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Collateral", (RosettaPath)path, (String)CollateralCollateralExists.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Collateral collateral) {
            try {
                return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)collateral).map("getIndependentAmount", _collateral -> _collateral.getIndependentAmount())).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)collateral).mapC("getCollateralPortfolio", _collateral -> _collateral.getCollateralPortfolio())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

