/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule.functions;

import cdm.product.common.schedule.CalculationPeriodData;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.schedule.functions.AdjustableDateUtils;
import cdm.product.common.schedule.functions.CalculationPeriod;
import cdm.product.common.schedule.functions.CalculationPeriods;
import cdm.product.common.schedule.functions.CdmToStrataMapper;
import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.basics.schedule.RollConvention;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.basics.schedule.StubConvention;
import com.rosetta.model.lib.records.Date;
import java.time.LocalDate;
import java.time.chrono.IsoChronology;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculationPeriodsImpl
extends CalculationPeriods {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculationPeriod.class);

    @Override
    protected List<CalculationPeriodData.CalculationPeriodDataBuilder> doEvaluate(CalculationPeriodDates calculationPeriodDates) {
        Date adjustedStartDate = AdjustableDateUtils.adjustDate(calculationPeriodDates.getEffectiveDate());
        Date adjustedEndDate = AdjustableDateUtils.adjustDate(calculationPeriodDates.getTerminationDate());
        ArrayList<CalculationPeriodData.CalculationPeriodDataBuilder> returnVal = new ArrayList<CalculationPeriodData.CalculationPeriodDataBuilder>();
        if (adjustedStartDate == null) {
            LOGGER.warn("Can not build CalculationPeriodData as no adjusted start date specified.");
            return returnVal;
        }
        if (adjustedEndDate == null) {
            LOGGER.warn("Can not build CalculationPeriodData as no adjusted end date specified.");
            return returnVal;
        }
        Schedule schedule = this.getSchedule(calculationPeriodDates, adjustedStartDate.toLocalDate(), adjustedEndDate.toLocalDate());
        ImmutableList periods = schedule.getPeriods();
        for (SchedulePeriod period : periods) {
            CalculationPeriodData.CalculationPeriodDataBuilder calcPeriod = this.getCalcPeriod(period);
            returnVal.add(calcPeriod);
        }
        return returnVal;
    }

    private CalculationPeriodData.CalculationPeriodDataBuilder getCalcPeriod(SchedulePeriod targetPeriod) {
        CalculationPeriodData.CalculationPeriodDataBuilder builder = CalculationPeriodData.builder();
        int daysThatAreInLeapYear = this.getDaysThatAreInLeapYear(targetPeriod);
        return builder.setStartDate(Date.of((LocalDate)targetPeriod.getStartDate())).setEndDate(Date.of((LocalDate)targetPeriod.getEndDate())).setDaysInLeapYearPeriod(daysThatAreInLeapYear).setDaysInPeriod((int)ChronoUnit.DAYS.between(targetPeriod.getStartDate(), targetPeriod.getEndDate())).setIsFirstPeriod(false).setIsLastPeriod(false);
    }

    private int getDaysThatAreInLeapYear(SchedulePeriod targetPeriod) {
        int daysThatAreInLeapYear = 0;
        LocalDate startDate = targetPeriod.getStartDate();
        while (startDate.isBefore(targetPeriod.getEndDate())) {
            if (IsoChronology.INSTANCE.isLeapYear(startDate.getYear())) {
                ++daysThatAreInLeapYear;
            }
            startDate = startDate.plusDays(1L);
        }
        return daysThatAreInLeapYear;
    }

    private Schedule getSchedule(CalculationPeriodDates calculationPeriodDates, LocalDate adjustedStartDate, LocalDate adjustedEndDate) {
        PeriodicSchedule periodicSchedule = PeriodicSchedule.of((LocalDate)adjustedStartDate, (LocalDate)adjustedEndDate, (Frequency)CdmToStrataMapper.getFrequency(calculationPeriodDates), (BusinessDayAdjustment)BusinessDayAdjustment.NONE, (StubConvention)StubConvention.NONE, (RollConvention)CdmToStrataMapper.getRollConvention(calculationPeriodDates));
        return periodicSchedule.createSchedule(ReferenceData.minimal());
    }
}

