/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.PerformancePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PerformancePayoutCorrelationUnderlierOnlyBasket")
@ImplementedBy(value=Default.class)
public interface PerformancePayoutCorrelationUnderlierOnlyBasket
extends Validator<PerformancePayout> {
    public static final String NAME = "PerformancePayoutCorrelationUnderlierOnlyBasket";
    public static final String DEFINITION = "if returnTerms -> correlationReturnTerms exists then underlier -> basket only exists";

    public static class NoOp
    implements PerformancePayoutCorrelationUnderlierOnlyBasket {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PerformancePayout performancePayout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PerformancePayoutCorrelationUnderlierOnlyBasket {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PerformancePayout performancePayout) {
            ComparisonResult result = this.executeDataRule(performancePayout);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PerformancePayoutCorrelationUnderlierOnlyBasket.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PerformancePayout", (RosettaPath)path, (String)PerformancePayoutCorrelationUnderlierOnlyBasket.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PerformancePayoutCorrelationUnderlierOnlyBasket.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PerformancePayout", (RosettaPath)path, (String)PerformancePayoutCorrelationUnderlierOnlyBasket.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PerformancePayout performancePayout) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)performancePayout).map("getReturnTerms", _performancePayout -> _performancePayout.getReturnTerms()).map("getCorrelationReturnTerms", returnTerms -> returnTerms.getCorrelationReturnTerms())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.onlyExists((Mapper)MapperS.of((Object)performancePayout).map("getUnderlier", _performancePayout -> _performancePayout.getUnderlier()), Arrays.asList("contractualProduct", "index", "loan", "assetPool", "foreignExchange", "commodity", "security", "basket"), Arrays.asList("basket"));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

