/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.util;

import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.TargetLanguageStringConcatenation;
import com.regnosys.rosetta.generator.java.scoping.JavaFileScope;
import com.regnosys.rosetta.generator.java.types.JavaTypeRepresentation;
import com.regnosys.rosetta.generator.java.util.PreferWildcardImportClass;
import com.regnosys.rosetta.generator.java.util.PreferWildcardImportMethod;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaType;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

class ImportingStringConcatenation
extends TargetLanguageStringConcatenation {
    private final Map<DottedPath, DottedPath> imports = new HashMap<DottedPath, DottedPath>();
    private final Map<DottedPath, DottedPath> staticImports = new HashMap<DottedPath, DottedPath>();
    private final JavaFileScope scope;

    public ImportingStringConcatenation(JavaFileScope topScope) {
        this.scope = topScope;
    }

    @Override
    protected void append(Object object, int index) {
        if (object instanceof JavaClass) {
            throw new IllegalStateException();
        }
        super.append(object, index);
    }

    @Override
    protected void append(Object object, String indentation, int index) {
        if (object instanceof JavaClass) {
            throw new IllegalStateException();
        }
        super.append(object, indentation, index);
    }

    @Override
    protected Object handle(Object object) {
        if (object instanceof JavaClass) {
            JavaClass clazz = (JavaClass)object;
            return this.getOrImportIdentifier(clazz, clazz.getPackageName(), clazz.getNestedTypeName());
        }
        if (object instanceof PreferWildcardImportClass) {
            PreferWildcardImportClass clazz = (PreferWildcardImportClass)object;
            JavaClass<?> jc = clazz.getJavaClass();
            return this.getOrWildcardImportIdentifier(jc, jc.getPackageName(), jc.getNestedTypeName());
        }
        if (object instanceof Method) {
            Method m = (Method)object;
            return this.getOrStaticImportIdentifier(m, DottedPath.splitOnDots((String)m.getDeclaringClass().getCanonicalName()), m.getName());
        }
        if (object instanceof PreferWildcardImportMethod) {
            PreferWildcardImportMethod pm = (PreferWildcardImportMethod)object;
            Method m = pm.getMethod();
            return this.getOrStaticWildcardImportIdentifier(m, DottedPath.splitOnDots((String)m.getDeclaringClass().getCanonicalName()), m.getName());
        }
        return super.handle(object);
    }

    @Override
    protected Object normalize(Object object) {
        Object n = super.normalize(object);
        JavaType t = JavaType.from((Object)n);
        if (t == null) {
            return n;
        }
        if (t instanceof JavaClass) {
            if (t instanceof JavaParameterizedType) {
                return new JavaTypeRepresentation(t);
            }
            return t;
        }
        return new JavaTypeRepresentation(t);
    }

    public GeneratedIdentifier getOrImportIdentifier(Object object, DottedPath packageName, DottedPath nestedTypeName) {
        return this.scope.getIdentifier(object).orElseGet(() -> this.internalDoImportIfPossible(object, nestedTypeName, packageName, topLevelTypeInFile -> this.addImportIfNotAlreadyImported(packageName, packageName.child(topLevelTypeInFile))));
    }

    public GeneratedIdentifier getOrWildcardImportIdentifier(Object object, DottedPath packageName, DottedPath nestedTypeName) {
        DottedPath canonicalName = packageName.concat(nestedTypeName);
        return this.scope.getIdentifier(object).map(it -> {
            if (this.imports.containsKey(canonicalName)) {
                this.addWildcardImport(packageName);
            }
            return it;
        }).orElseGet(() -> this.internalDoImportIfPossible(object, nestedTypeName, packageName, topLevelTypeInFile -> this.addWildcardImport(packageName)));
    }

    private GeneratedIdentifier internalDoImportIfPossible(Object object, DottedPath nestedTypeName, DottedPath packageName, Consumer<String> addImport) {
        String desiredName = nestedTypeName.withDots();
        String topLevelTypeInFile = nestedTypeName.first();
        DottedPath topLevelCanonicalName = packageName.child(topLevelTypeInFile);
        if (!this.scope.isNameTaken(desiredName) && this.isAlreadyAccessible(packageName, topLevelCanonicalName)) {
            return this.scope.createIdentifier(object, desiredName);
        }
        if (this.scope.isNameTaken(topLevelTypeInFile)) {
            DottedPath canonicalName = packageName.concat(nestedTypeName);
            return this.scope.createIdentifier(object, canonicalName.withDots());
        }
        addImport.accept(topLevelTypeInFile);
        return this.scope.createIdentifier(object, desiredName);
    }

    public GeneratedIdentifier getOrStaticImportIdentifier(Object object, DottedPath canonicalClassName, String staticMemberName) {
        DottedPath canonicalStaticMemberName = canonicalClassName.child(staticMemberName);
        return this.scope.getIdentifier(object).orElseGet(() -> this.internalDoStaticImportIfPossible(object, staticMemberName, canonicalStaticMemberName, () -> this.addStaticImportIfNotAlreadyImported(canonicalClassName, canonicalStaticMemberName)));
    }

    public GeneratedIdentifier getOrStaticWildcardImportIdentifier(Object object, DottedPath canonicalClassName, String staticMemberName) {
        DottedPath canonicalStaticMemberName = canonicalClassName.child(staticMemberName);
        return this.scope.getIdentifier(object).map(it -> {
            if (this.staticImports.containsKey(canonicalStaticMemberName)) {
                this.addStaticWildcardImport(canonicalClassName);
            }
            return it;
        }).orElseGet(() -> this.internalDoStaticImportIfPossible(object, staticMemberName, canonicalStaticMemberName, () -> this.addStaticWildcardImport(canonicalClassName)));
    }

    private GeneratedIdentifier internalDoStaticImportIfPossible(Object object, String staticMemberName, DottedPath canonicalStaticMemberName, Runnable addImport) {
        if (this.scope.isNameTaken(staticMemberName)) {
            return this.scope.createIdentifier(object, canonicalStaticMemberName.withDots());
        }
        addImport.run();
        return this.scope.createIdentifier(object, staticMemberName);
    }

    public void addImportIfNotAlreadyImported(DottedPath packageName, DottedPath canonicalName) {
        if (this.needsImport(packageName)) {
            this.imports.put(canonicalName, packageName);
        }
    }

    private boolean needsImport(DottedPath packageName) {
        return !packageName.equals((Object)this.scope.getPackageName()) && !this.imports.containsKey(packageName.child("*"));
    }

    public boolean isAlreadyAccessible(DottedPath packageName, DottedPath canonicalName) {
        return !this.needsImport(packageName) || this.imports.containsKey(canonicalName);
    }

    public void addWildcardImport(DottedPath packageName) {
        DottedPath wildcard = packageName.child("*");
        if (!packageName.equals((Object)this.scope.getPackageName()) && this.imports.put(wildcard, packageName) == null) {
            this.imports.entrySet().removeIf(imp -> !((DottedPath)imp.getKey()).equals((Object)wildcard) && ((DottedPath)imp.getValue()).equals((Object)packageName));
        }
    }

    public void addStaticImportIfNotAlreadyImported(DottedPath canonicalClassName, DottedPath canonicalStaticMemberName) {
        if (!this.staticImports.containsKey(canonicalClassName.child("*"))) {
            this.staticImports.put(canonicalStaticMemberName, canonicalClassName);
        }
    }

    public void addStaticWildcardImport(DottedPath canonicalClassName) {
        DottedPath wildcard = canonicalClassName.child("*");
        if (this.staticImports.put(wildcard, canonicalClassName) == null) {
            this.staticImports.entrySet().removeIf(imp -> !((DottedPath)imp.getKey()).equals((Object)wildcard) && ((DottedPath)imp.getValue()).equals((Object)canonicalClassName));
        }
    }

    public List<DottedPath> getImports() {
        return this.imports.keySet().stream().sorted().toList();
    }

    public List<DottedPath> getStaticImports() {
        return this.staticImports.keySet().stream().sorted().toList();
    }
}

