/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.utils;

import com.google.common.collect.Iterables;
import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration;
import com.regnosys.rosetta.rosetta.RosettaQualifiableType;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.simple.Data;
import jakarta.inject.Inject;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;

public class RosettaConfigExtension {
    @Inject
    private IResourceDescriptionsProvider index;
    @Inject
    private RosettaEcoreUtil rosettaEcoreUtil;

    public boolean isRootEventOrProduct(RosettaType type) {
        return type.getName() != null && (Objects.equals(type, this.findEventRootName(type)) || Objects.equals(type, this.findProductRootName(type)));
    }

    public Data findProductRootName(EObject ctx) {
        return this.findRosettaQualifiableConfiguration(ctx, RosettaQualifiableType.PRODUCT);
    }

    public Data findEventRootName(EObject ctx) {
        return this.findRosettaQualifiableConfiguration(ctx, RosettaQualifiableType.EVENT);
    }

    @Deprecated
    public Iterable<IEObjectDescription> findMetaTypes(Iterable<String> names, EObject ctx) {
        IResourceDescriptions descriptions = this.index.getResourceDescriptions(ctx.eResource().getResourceSet());
        return Iterables.filter((Iterable)Iterables.concat((Iterable)Iterables.transform(names, name -> descriptions.getExportedObjects(RosettaPackage.Literals.ROSETTA_META_TYPE, QualifiedName.create((String)name), false))), it -> this.isProjectLocal(ctx.eResource().getURI(), it.getEObjectURI()));
    }

    public boolean isProjectLocal(URI platformResourceURI, URI candidateUri) {
        if (!platformResourceURI.isPlatformResource()) {
            return true;
        }
        String projectName = platformResourceURI.segment(1);
        if (candidateUri.isPlatformResource()) {
            return Objects.equals(projectName, candidateUri.segment(1));
        }
        return false;
    }

    private Data findRosettaQualifiableConfiguration(EObject ctx, RosettaQualifiableType type) {
        Iterable filtered = Iterables.filter((Iterable)this.index.getResourceDescriptions(ctx.eResource().getResourceSet()).getExportedObjectsByType(RosettaPackage.Literals.ROSETTA_QUALIFIABLE_CONFIGURATION), it -> this.isProjectLocal(ctx.eResource().getURI(), it.getEObjectURI()));
        Iterable mapped = Iterables.transform((Iterable)filtered, it -> {
            EObject eObj;
            EObject eObject = eObj = it.getEObjectOrProxy().eIsProxy() ? EcoreUtil.resolve((EObject)it.getEObjectOrProxy(), (EObject)ctx) : it.getEObjectOrProxy();
            if (this.rosettaEcoreUtil.isResolved(eObj) && type == ((RosettaQualifiableConfiguration)eObj).getQType()) {
                return ((RosettaQualifiableConfiguration)eObj).getRosettaClass();
            }
            return null;
        });
        return (Data)Iterables.getFirst((Iterable)Iterables.filter((Iterable)mapped, Objects::nonNull), null);
    }
}

