/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.regnosys.rosetta.generator.util.RosettaFunctionExtensions;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.utils.CsvUtil;
import com.regnosys.rosetta.validation.AbstractDeclarativeRosettaValidator;
import com.regnosys.rosetta.validation.WarningSuppressionHelper;
import jakarta.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class FunctionValidator
extends AbstractDeclarativeRosettaValidator {
    @Inject
    private RosettaFunctionExtensions functionExtensions;
    @Inject
    private CsvUtil csvUtil;
    @Inject
    private RObjectFactory rObjectFactory;
    @Inject
    private WarningSuppressionHelper warningSuppressionHelper;

    @Check
    public void checkFunctionNameStartsWithCapital(Function func) {
        boolean suppressed = this.warningSuppressionHelper.isCapitalisationSuppressed(func);
        if (!suppressed && Character.isLowerCase(func.getName().charAt(0))) {
            this.warning("Function name should start with a capital", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidCase", new String[0]);
        }
    }

    @Check
    public void checkCsvIngestionInput(Function function) {
        if (this.hasCsvTransformAnnotation(function, "ingest") && !function.getInputs().isEmpty()) {
            this.checkAttributeIsTabular((Attribute)function.getInputs().get(0), "The input of a CSV ingest function");
        }
    }

    @Check
    public void checkCsvProjectionOutput(Function function) {
        Attribute output;
        if (this.hasCsvTransformAnnotation(function, "projection") && (output = function.getOutput()) != null) {
            this.checkAttributeIsTabular(output, "The output of a CSV projection function");
        }
    }

    private void checkAttributeIsTabular(Attribute attribute, String attributeDescription) {
        RAttribute attr = this.rObjectFactory.buildRAttribute(attribute);
        RType t = attr.getRMetaAnnotatedType().getRType();
        if (!(t instanceof RDataType)) {
            this.error(attributeDescription + " must be a complex type", attribute, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_TYPED__TYPE_CALL);
        } else {
            RDataType dt = (RDataType)t;
            List<RAttribute> nonSimple = this.csvUtil.getNonSimpleAttributes(dt);
            if (!nonSimple.isEmpty()) {
                String attrs = nonSimple.stream().map(a -> "`" + a.getName() + "`").collect(Collectors.joining(", "));
                this.error(attributeDescription + " must be a tabular type. Type `" + dt.getName() + "` has non-simple attributes: " + attrs, attribute, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_TYPED__TYPE_CALL);
            }
        }
        if (attr.isMulti()) {
            this.error(attributeDescription + " must be single cardinality", attribute, (EStructuralFeature)SimplePackage.Literals.ATTRIBUTE__CARD);
        }
    }

    private boolean hasCsvTransformAnnotation(Function function, String transformName) {
        return this.functionExtensions.getTransformAnnotations(function).stream().filter(a -> a.getAttribute() != null && "CSV".equals(a.getAttribute().getName())).map(AnnotationRef::getAnnotation).anyMatch(a -> a != null && transformName.equals(a.getName()));
    }

    @Check
    public void warnWhenEmptyFunctionsDontHaveCodeImplementationAnnotation(Function function) {
        if (function.getOutput() != null && function.getOutput().getName() != null) {
            Function annotated = function;
            boolean hasCodeImplementationAnnotation = annotated.getAnnotations().stream().map(aRef -> aRef.getAnnotation()).anyMatch(a -> "codeImplementation".equals(a.getName()));
            if (function.getOperations().isEmpty() && !hasCodeImplementationAnnotation) {
                this.warning("A function should specify an implementation, or they should be annotated with codeImplementation", function, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
            }
            if (!function.getOperations().isEmpty() && hasCodeImplementationAnnotation) {
                this.warning("Functions annotated with codeImplementation should not have any setter operations as they will be overriden", function, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
            }
        }
    }
}

