package iso20022.auth030.asic.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.asic.Direction4Choice;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class Direction4ChoiceTypeFormatValidator implements Validator<Direction4Choice> {

	private List<ComparisonResult> getComparisonResults(Direction4Choice o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public ValidationResult<Direction4Choice> validate(RosettaPath path, Direction4Choice o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("Direction4Choice", ValidationType.TYPE_FORMAT, "Direction4Choice", path, "", error);
		}
		return success("Direction4Choice", ValidationType.TYPE_FORMAT, "Direction4Choice", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, Direction4Choice o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("Direction4Choice", ValidationType.TYPE_FORMAT, "Direction4Choice", path, "", res.getError());
				}
				return success("Direction4Choice", ValidationType.TYPE_FORMAT, "Direction4Choice", path, "");
			})
			.collect(toList());
	}

}
