package iso20022.auth030.asic.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.asic.InstrumentIdentification6Choice__1;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("InstrumentIdentification6Choice__1Choice")
@ImplementedBy(InstrumentIdentification6Choice1Choice.Default.class)
public interface InstrumentIdentification6Choice1Choice extends Validator<InstrumentIdentification6Choice__1> {
	
	String NAME = "InstrumentIdentification6Choice__1Choice";
	String DEFINITION = "one-of";
	
	ValidationResult<InstrumentIdentification6Choice__1> validate(RosettaPath path, InstrumentIdentification6Choice__1 instrumentIdentification6Choice__1);
	
	class Default implements InstrumentIdentification6Choice1Choice {
	
		@Override
		public ValidationResult<InstrumentIdentification6Choice__1> validate(RosettaPath path, InstrumentIdentification6Choice__1 instrumentIdentification6Choice__1) {
			ComparisonResult result = executeDataRule(instrumentIdentification6Choice__1);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "InstrumentIdentification6Choice__1", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "InstrumentIdentification6Choice__1", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(InstrumentIdentification6Choice__1 instrumentIdentification6Choice__1) {
			try {
				return choice(MapperS.of(instrumentIdentification6Choice__1), Arrays.asList("isin", "othrId"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements InstrumentIdentification6Choice1Choice {
	
		@Override
		public ValidationResult<InstrumentIdentification6Choice__1> validate(RosettaPath path, InstrumentIdentification6Choice__1 instrumentIdentification6Choice__1) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "InstrumentIdentification6Choice__1", path, DEFINITION);
		}
	}
}
