package iso20022.auth030.asic.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.asic.InterestRate33Choice__2;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("InterestRate33Choice__2Choice")
@ImplementedBy(InterestRate33Choice2Choice.Default.class)
public interface InterestRate33Choice2Choice extends Validator<InterestRate33Choice__2> {
	
	String NAME = "InterestRate33Choice__2Choice";
	String DEFINITION = "one-of";
	
	ValidationResult<InterestRate33Choice__2> validate(RosettaPath path, InterestRate33Choice__2 interestRate33Choice__2);
	
	class Default implements InterestRate33Choice2Choice {
	
		@Override
		public ValidationResult<InterestRate33Choice__2> validate(RosettaPath path, InterestRate33Choice__2 interestRate33Choice__2) {
			ComparisonResult result = executeDataRule(interestRate33Choice__2);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "InterestRate33Choice__2", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "InterestRate33Choice__2", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(InterestRate33Choice__2 interestRate33Choice__2) {
			try {
				return choice(MapperS.of(interestRate33Choice__2), Arrays.asList("fxd", "fltg"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements InterestRate33Choice2Choice {
	
		@Override
		public ValidationResult<InterestRate33Choice__2> validate(RosettaPath path, InterestRate33Choice__2 interestRate33Choice__2) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "InterestRate33Choice__2", path, DEFINITION);
		}
	}
}
