package iso20022.auth030.esma;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.esma.AgriculturalCommoditySoft2;
import iso20022.auth030.esma.AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder;
import iso20022.auth030.esma.AgriculturalCommoditySoft2.AgriculturalCommoditySoft2BuilderImpl;
import iso20022.auth030.esma.AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Impl;
import iso20022.auth030.esma.AssetClassDetailedSubProductType2Code;
import iso20022.auth030.esma.AssetClassProductType1Code;
import iso20022.auth030.esma.AssetClassSubProductType2Code;
import iso20022.auth030.esma.meta.AgriculturalCommoditySoft2Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of an agricultural derivative of type soft.
 * @version ${project.version}
 */
@RosettaDataType(value="AgriculturalCommoditySoft2", builder=AgriculturalCommoditySoft2.AgriculturalCommoditySoft2BuilderImpl.class, version="${project.version}")
public interface AgriculturalCommoditySoft2 extends RosettaModelObject {

	AgriculturalCommoditySoft2Meta metaData = new AgriculturalCommoditySoft2Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType1Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType2Code getSubPdct();
	/**
	 * Further subproduct type related to instruments that have a non-financial instrument or commodity as underlying.
	 */
	AssetClassDetailedSubProductType2Code getAddtlSubPdct();

	/*********************** Build Methods  ***********************/
	AgriculturalCommoditySoft2 build();
	
	AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder toBuilder();
	
	static AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder builder() {
		return new AgriculturalCommoditySoft2.AgriculturalCommoditySoft2BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends AgriculturalCommoditySoft2> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends AgriculturalCommoditySoft2> getType() {
		return AgriculturalCommoditySoft2.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType1Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType2Code.class, getSubPdct(), this);
		processor.processBasic(path.newSubPath("addtlSubPdct"), AssetClassDetailedSubProductType2Code.class, getAddtlSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface AgriculturalCommoditySoft2Builder extends AgriculturalCommoditySoft2, RosettaModelObjectBuilder {
		AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder setBasePdct(AssetClassProductType1Code basePdct);
		AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder setSubPdct(AssetClassSubProductType2Code subPdct);
		AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder setAddtlSubPdct(AssetClassDetailedSubProductType2Code addtlSubPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType1Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType2Code.class, getSubPdct(), this);
			processor.processBasic(path.newSubPath("addtlSubPdct"), AssetClassDetailedSubProductType2Code.class, getAddtlSubPdct(), this);
		}
		

		AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder prune();
	}

	/*********************** Immutable Implementation of AgriculturalCommoditySoft2  ***********************/
	class AgriculturalCommoditySoft2Impl implements AgriculturalCommoditySoft2 {
		private final AssetClassProductType1Code basePdct;
		private final AssetClassSubProductType2Code subPdct;
		private final AssetClassDetailedSubProductType2Code addtlSubPdct;
		
		protected AgriculturalCommoditySoft2Impl(AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
			this.addtlSubPdct = builder.getAddtlSubPdct();
		}
		
		@Override
		@RosettaAttribute("basePdct")
		public AssetClassProductType1Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public AssetClassSubProductType2Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		public AssetClassDetailedSubProductType2Code getAddtlSubPdct() {
			return addtlSubPdct;
		}
		
		@Override
		public AgriculturalCommoditySoft2 build() {
			return this;
		}
		
		@Override
		public AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder toBuilder() {
			AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
			ofNullable(getAddtlSubPdct()).ifPresent(builder::setAddtlSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AgriculturalCommoditySoft2 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			if (!Objects.equals(addtlSubPdct, _that.getAddtlSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (addtlSubPdct != null ? addtlSubPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AgriculturalCommoditySoft2 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct + ", " +
				"addtlSubPdct=" + this.addtlSubPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of AgriculturalCommoditySoft2  ***********************/
	class AgriculturalCommoditySoft2BuilderImpl implements AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder {
	
		protected AssetClassProductType1Code basePdct;
		protected AssetClassSubProductType2Code subPdct;
		protected AssetClassDetailedSubProductType2Code addtlSubPdct;
		
		@Override
		@RosettaAttribute("basePdct")
		public AssetClassProductType1Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public AssetClassSubProductType2Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		public AssetClassDetailedSubProductType2Code getAddtlSubPdct() {
			return addtlSubPdct;
		}
		
		@Override
		@RosettaAttribute("basePdct")
		public AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder setBasePdct(AssetClassProductType1Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder setSubPdct(AssetClassSubProductType2Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		public AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder setAddtlSubPdct(AssetClassDetailedSubProductType2Code _addtlSubPdct) {
			this.addtlSubPdct = _addtlSubPdct == null ? null : _addtlSubPdct;
			return this;
		}
		
		@Override
		public AgriculturalCommoditySoft2 build() {
			return new AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Impl(this);
		}
		
		@Override
		public AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			if (getAddtlSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder o = (AgriculturalCommoditySoft2.AgriculturalCommoditySoft2Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			merger.mergeBasic(getAddtlSubPdct(), o.getAddtlSubPdct(), this::setAddtlSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AgriculturalCommoditySoft2 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			if (!Objects.equals(addtlSubPdct, _that.getAddtlSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (addtlSubPdct != null ? addtlSubPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AgriculturalCommoditySoft2Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct + ", " +
				"addtlSubPdct=" + this.addtlSubPdct +
			'}';
		}
	}
}
