package iso20022.auth030.esma.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.esma.FertilizerCommoditySulphur2;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class FertilizerCommoditySulphur2TypeFormatValidator implements Validator<FertilizerCommoditySulphur2> {

	private List<ComparisonResult> getComparisonResults(FertilizerCommoditySulphur2 o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public ValidationResult<FertilizerCommoditySulphur2> validate(RosettaPath path, FertilizerCommoditySulphur2 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("FertilizerCommoditySulphur2", ValidationType.TYPE_FORMAT, "FertilizerCommoditySulphur2", path, "", error);
		}
		return success("FertilizerCommoditySulphur2", ValidationType.TYPE_FORMAT, "FertilizerCommoditySulphur2", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, FertilizerCommoditySulphur2 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("FertilizerCommoditySulphur2", ValidationType.TYPE_FORMAT, "FertilizerCommoditySulphur2", path, "", res.getError());
				}
				return success("FertilizerCommoditySulphur2", ValidationType.TYPE_FORMAT, "FertilizerCommoditySulphur2", path, "");
			})
			.collect(toList());
	}

}
