package iso20022.auth030.esma.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.esma.LegalPersonIdentification1__1;
import iso20022.auth030.esma.NaturalPersonIdentification3__2;
import iso20022.auth030.esma.PartyIdentification248Choice__3;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class PartyIdentification248Choice__3Validator implements Validator<PartyIdentification248Choice__3> {

	private List<ComparisonResult> getComparisonResults(PartyIdentification248Choice__3 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("lgl", (LegalPersonIdentification1__1) o.getLgl() != null ? 1 : 0, 0, 1), 
				checkCardinality("ntrl", (NaturalPersonIdentification3__2) o.getNtrl() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public ValidationResult<PartyIdentification248Choice__3> validate(RosettaPath path, PartyIdentification248Choice__3 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("PartyIdentification248Choice__3", ValidationType.CARDINALITY, "PartyIdentification248Choice__3", path, "", error);
		}
		return success("PartyIdentification248Choice__3", ValidationType.CARDINALITY, "PartyIdentification248Choice__3", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, PartyIdentification248Choice__3 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("PartyIdentification248Choice__3", ValidationType.CARDINALITY, "PartyIdentification248Choice__3", path, "", res.getError());
				}
				return success("PartyIdentification248Choice__3", ValidationType.CARDINALITY, "PartyIdentification248Choice__3", path, "");
			})
			.collect(toList());
	}

}
