package iso20022.auth030.esma.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.esma.AssetClassCommodityEnergy3Choice;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("AssetClassCommodityEnergy3ChoiceChoice")
@ImplementedBy(AssetClassCommodityEnergy3ChoiceChoice.Default.class)
public interface AssetClassCommodityEnergy3ChoiceChoice extends Validator<AssetClassCommodityEnergy3Choice> {
	
	String NAME = "AssetClassCommodityEnergy3ChoiceChoice";
	String DEFINITION = "one-of";
	
	ValidationResult<AssetClassCommodityEnergy3Choice> validate(RosettaPath path, AssetClassCommodityEnergy3Choice assetClassCommodityEnergy3Choice);
	
	class Default implements AssetClassCommodityEnergy3ChoiceChoice {
	
		@Override
		public ValidationResult<AssetClassCommodityEnergy3Choice> validate(RosettaPath path, AssetClassCommodityEnergy3Choice assetClassCommodityEnergy3Choice) {
			ComparisonResult result = executeDataRule(assetClassCommodityEnergy3Choice);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodityEnergy3Choice", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "AssetClassCommodityEnergy3Choice", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(AssetClassCommodityEnergy3Choice assetClassCommodityEnergy3Choice) {
			try {
				return choice(MapperS.of(assetClassCommodityEnergy3Choice), Arrays.asList("elctrcty", "ntrlGas", "oil", "coal", "intrNrgy", "rnwblNrgy", "lghtEnd", "dstllts", "othr"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements AssetClassCommodityEnergy3ChoiceChoice {
	
		@Override
		public ValidationResult<AssetClassCommodityEnergy3Choice> validate(RosettaPath path, AssetClassCommodityEnergy3Choice assetClassCommodityEnergy3Choice) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodityEnergy3Choice", path, DEFINITION);
		}
	}
}
