package iso20022.auth030.esma.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.esma.CounterpartyTradeNature15Choice__1;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("CounterpartyTradeNature15Choice__1Choice")
@ImplementedBy(CounterpartyTradeNature15Choice1Choice.Default.class)
public interface CounterpartyTradeNature15Choice1Choice extends Validator<CounterpartyTradeNature15Choice__1> {
	
	String NAME = "CounterpartyTradeNature15Choice__1Choice";
	String DEFINITION = "one-of";
	
	ValidationResult<CounterpartyTradeNature15Choice__1> validate(RosettaPath path, CounterpartyTradeNature15Choice__1 counterpartyTradeNature15Choice__1);
	
	class Default implements CounterpartyTradeNature15Choice1Choice {
	
		@Override
		public ValidationResult<CounterpartyTradeNature15Choice__1> validate(RosettaPath path, CounterpartyTradeNature15Choice__1 counterpartyTradeNature15Choice__1) {
			ComparisonResult result = executeDataRule(counterpartyTradeNature15Choice__1);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CounterpartyTradeNature15Choice__1", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "CounterpartyTradeNature15Choice__1", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(CounterpartyTradeNature15Choice__1 counterpartyTradeNature15Choice__1) {
			try {
				return choice(MapperS.of(counterpartyTradeNature15Choice__1), Arrays.asList("fi", "nfi", "cntrlCntrPty", "othr"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CounterpartyTradeNature15Choice1Choice {
	
		@Override
		public ValidationResult<CounterpartyTradeNature15Choice__1> validate(RosettaPath path, CounterpartyTradeNature15Choice__1 counterpartyTradeNature15Choice__1) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CounterpartyTradeNature15Choice__1", path, DEFINITION);
		}
	}
}
