package iso20022.auth030.fca.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.fca.DeliveryInterconnectionPoint1Choice__1;
import iso20022.auth030.fca.EnergyLoadType1Code;
import iso20022.auth030.fca.EnergySpecificAttribute9__1;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class EnergySpecificAttribute9__1Validator implements Validator<EnergySpecificAttribute9__1> {

	private List<ComparisonResult> getComparisonResults(EnergySpecificAttribute9__1 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("dlvryPtOrZone", (DeliveryInterconnectionPoint1Choice__1) o.getDlvryPtOrZone() != null ? 1 : 0, 0, 1), 
				checkCardinality("intrCnnctnPt", (DeliveryInterconnectionPoint1Choice__1) o.getIntrCnnctnPt() != null ? 1 : 0, 0, 1), 
				checkCardinality("ldTp", (EnergyLoadType1Code) o.getLdTp() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public ValidationResult<EnergySpecificAttribute9__1> validate(RosettaPath path, EnergySpecificAttribute9__1 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("EnergySpecificAttribute9__1", ValidationType.CARDINALITY, "EnergySpecificAttribute9__1", path, "", error);
		}
		return success("EnergySpecificAttribute9__1", ValidationType.CARDINALITY, "EnergySpecificAttribute9__1", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, EnergySpecificAttribute9__1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("EnergySpecificAttribute9__1", ValidationType.CARDINALITY, "EnergySpecificAttribute9__1", path, "", res.getError());
				}
				return success("EnergySpecificAttribute9__1", ValidationType.CARDINALITY, "EnergySpecificAttribute9__1", path, "");
			})
			.collect(toList());
	}

}
