package iso20022.auth030.fca.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.fca.PortfolioCode3Choice;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("PortfolioCode3ChoiceChoice")
@ImplementedBy(PortfolioCode3ChoiceChoice.Default.class)
public interface PortfolioCode3ChoiceChoice extends Validator<PortfolioCode3Choice> {
	
	String NAME = "PortfolioCode3ChoiceChoice";
	String DEFINITION = "one-of";
	
	ValidationResult<PortfolioCode3Choice> validate(RosettaPath path, PortfolioCode3Choice portfolioCode3Choice);
	
	class Default implements PortfolioCode3ChoiceChoice {
	
		@Override
		public ValidationResult<PortfolioCode3Choice> validate(RosettaPath path, PortfolioCode3Choice portfolioCode3Choice) {
			ComparisonResult result = executeDataRule(portfolioCode3Choice);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "PortfolioCode3Choice", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "PortfolioCode3Choice", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(PortfolioCode3Choice portfolioCode3Choice) {
			try {
				return choice(MapperS.of(portfolioCode3Choice), Arrays.asList("cd", "noPrtfl"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements PortfolioCode3ChoiceChoice {
	
		@Override
		public ValidationResult<PortfolioCode3Choice> validate(RosettaPath path, PortfolioCode3Choice portfolioCode3Choice) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "PortfolioCode3Choice", path, DEFINITION);
		}
	}
}
