package iso20022.auth030.hkma.tr.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.tr.ActiveOrHistoricCurrencyAnd13DecimalAmount;
import java.math.BigDecimal;
import java.util.List;
import java.util.regex.Pattern;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkNumber;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class ActiveOrHistoricCurrencyAnd13DecimalAmountTypeFormatValidator implements Validator<ActiveOrHistoricCurrencyAnd13DecimalAmount> {

	private List<ComparisonResult> getComparisonResults(ActiveOrHistoricCurrencyAnd13DecimalAmount o) {
		return Lists.<ComparisonResult>newArrayList(
				checkNumber("value", o.getValue(), of(18), of(13), of(new BigDecimal("0")), empty()), 
				checkString("ccy", o.getCcy(), 0, empty(), of(Pattern.compile("[A-Z]{3,3}")))
			);
	}

	@Override
	public ValidationResult<ActiveOrHistoricCurrencyAnd13DecimalAmount> validate(RosettaPath path, ActiveOrHistoricCurrencyAnd13DecimalAmount o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("ActiveOrHistoricCurrencyAnd13DecimalAmount", ValidationType.TYPE_FORMAT, "ActiveOrHistoricCurrencyAnd13DecimalAmount", path, "", error);
		}
		return success("ActiveOrHistoricCurrencyAnd13DecimalAmount", ValidationType.TYPE_FORMAT, "ActiveOrHistoricCurrencyAnd13DecimalAmount", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ActiveOrHistoricCurrencyAnd13DecimalAmount o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ActiveOrHistoricCurrencyAnd13DecimalAmount", ValidationType.TYPE_FORMAT, "ActiveOrHistoricCurrencyAnd13DecimalAmount", path, "", res.getError());
				}
				return success("ActiveOrHistoricCurrencyAnd13DecimalAmount", ValidationType.TYPE_FORMAT, "ActiveOrHistoricCurrencyAnd13DecimalAmount", path, "");
			})
			.collect(toList());
	}

}
