package iso20022.auth030.hkma.tr.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.tr.AssetClassCommodityC10Other1;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class AssetClassCommodityC10Other1TypeFormatValidator implements Validator<AssetClassCommodityC10Other1> {

	private List<ComparisonResult> getComparisonResults(AssetClassCommodityC10Other1 o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public ValidationResult<AssetClassCommodityC10Other1> validate(RosettaPath path, AssetClassCommodityC10Other1 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("AssetClassCommodityC10Other1", ValidationType.TYPE_FORMAT, "AssetClassCommodityC10Other1", path, "", error);
		}
		return success("AssetClassCommodityC10Other1", ValidationType.TYPE_FORMAT, "AssetClassCommodityC10Other1", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetClassCommodityC10Other1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("AssetClassCommodityC10Other1", ValidationType.TYPE_FORMAT, "AssetClassCommodityC10Other1", path, "", res.getError());
				}
				return success("AssetClassCommodityC10Other1", ValidationType.TYPE_FORMAT, "AssetClassCommodityC10Other1", path, "");
			})
			.collect(toList());
	}

}
