package iso20022.auth030.hkma.tr.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.tr.GenericIdentification184;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class GenericIdentification184Validator implements Validator<GenericIdentification184> {

	private List<ComparisonResult> getComparisonResults(GenericIdentification184 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("id", (String) o.getId() != null ? 1 : 0, 1, 1), 
				checkCardinality("src", (String) o.getSrc() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public ValidationResult<GenericIdentification184> validate(RosettaPath path, GenericIdentification184 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("GenericIdentification184", ValidationType.CARDINALITY, "GenericIdentification184", path, "", error);
		}
		return success("GenericIdentification184", ValidationType.CARDINALITY, "GenericIdentification184", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, GenericIdentification184 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("GenericIdentification184", ValidationType.CARDINALITY, "GenericIdentification184", path, "", res.getError());
				}
				return success("GenericIdentification184", ValidationType.CARDINALITY, "GenericIdentification184", path, "");
			})
			.collect(toList());
	}

}
