package iso20022.auth030.hkma.tr.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.hkma.tr.AssetClassDetailedSubProductType33Code;
import iso20022.auth030.hkma.tr.AssetClassProductType4Code;
import iso20022.auth030.hkma.tr.AssetClassSubProductType31Code;
import iso20022.auth030.hkma.tr.FreightCommodityDry3;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class FreightCommodityDry3OnlyExistsValidator implements ValidatorWithArg<FreightCommodityDry3, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends FreightCommodityDry3> ValidationResult<FreightCommodityDry3> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("basePdct", ExistenceChecker.isSet((AssetClassProductType4Code) o.getBasePdct()))
				.put("subPdct", ExistenceChecker.isSet((AssetClassSubProductType31Code) o.getSubPdct()))
				.put("addtlSubPdct", ExistenceChecker.isSet((AssetClassDetailedSubProductType33Code) o.getAddtlSubPdct()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("FreightCommodityDry3", ValidationType.ONLY_EXISTS, "FreightCommodityDry3", path, "");
		}
		return failure("FreightCommodityDry3", ValidationType.ONLY_EXISTS, "FreightCommodityDry3", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
