package iso20022.auth030.jfsa.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.jfsa.Cleared23Choice__2;
import iso20022.auth030.jfsa.ClearingExceptionOrExemption3Choice__1;
import iso20022.auth030.jfsa.ClearingPartyAndTime21Choice__2;
import iso20022.auth030.jfsa.ClearingPartyAndTime22Choice__2;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class Cleared23Choice__2Validator implements Validator<Cleared23Choice__2> {

	private List<ComparisonResult> getComparisonResults(Cleared23Choice__2 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("clrd", (ClearingPartyAndTime21Choice__2) o.getClrd() != null ? 1 : 0, 0, 1), 
				checkCardinality("intndToClear", (ClearingPartyAndTime22Choice__2) o.getIntndToClear() != null ? 1 : 0, 0, 1), 
				checkCardinality("nonClrd", (ClearingExceptionOrExemption3Choice__1) o.getNonClrd() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public ValidationResult<Cleared23Choice__2> validate(RosettaPath path, Cleared23Choice__2 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("Cleared23Choice__2", ValidationType.CARDINALITY, "Cleared23Choice__2", path, "", error);
		}
		return success("Cleared23Choice__2", ValidationType.CARDINALITY, "Cleared23Choice__2", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, Cleared23Choice__2 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("Cleared23Choice__2", ValidationType.CARDINALITY, "Cleared23Choice__2", path, "", res.getError());
				}
				return success("Cleared23Choice__2", ValidationType.CARDINALITY, "Cleared23Choice__2", path, "");
			})
			.collect(toList());
	}

}
