package iso20022.auth030.mas.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.mas.OrganisationIdentification15Choice__3;
import java.util.List;
import java.util.regex.Pattern;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class OrganisationIdentification15Choice__3TypeFormatValidator implements Validator<OrganisationIdentification15Choice__3> {

	private List<ComparisonResult> getComparisonResults(OrganisationIdentification15Choice__3 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("lei", o.getLei(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}")))
			);
	}

	@Override
	public ValidationResult<OrganisationIdentification15Choice__3> validate(RosettaPath path, OrganisationIdentification15Choice__3 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("OrganisationIdentification15Choice__3", ValidationType.TYPE_FORMAT, "OrganisationIdentification15Choice__3", path, "", error);
		}
		return success("OrganisationIdentification15Choice__3", ValidationType.TYPE_FORMAT, "OrganisationIdentification15Choice__3", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, OrganisationIdentification15Choice__3 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("OrganisationIdentification15Choice__3", ValidationType.TYPE_FORMAT, "OrganisationIdentification15Choice__3", path, "", res.getError());
				}
				return success("OrganisationIdentification15Choice__3", ValidationType.TYPE_FORMAT, "OrganisationIdentification15Choice__3", path, "");
			})
			.collect(toList());
	}

}
