package iso20022.auth108.fca.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth108.fca.TradeData55Choice__1;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("TradeData55Choice__1Choice")
@ImplementedBy(TradeData55Choice1Choice.Default.class)
public interface TradeData55Choice1Choice extends Validator<TradeData55Choice__1> {
	
	String NAME = "TradeData55Choice__1Choice";
	String DEFINITION = "one-of";
	
	ValidationResult<TradeData55Choice__1> validate(RosettaPath path, TradeData55Choice__1 tradeData55Choice__1);
	
	class Default implements TradeData55Choice1Choice {
	
		@Override
		public ValidationResult<TradeData55Choice__1> validate(RosettaPath path, TradeData55Choice__1 tradeData55Choice__1) {
			ComparisonResult result = executeDataRule(tradeData55Choice__1);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "TradeData55Choice__1", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "TradeData55Choice__1", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(TradeData55Choice__1 tradeData55Choice__1) {
			try {
				return choice(MapperS.of(tradeData55Choice__1), Arrays.asList("dataSetActn", "rpt"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements TradeData55Choice1Choice {
	
		@Override
		public ValidationResult<TradeData55Choice__1> validate(RosettaPath path, TradeData55Choice__1 tradeData55Choice__1) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "TradeData55Choice__1", path, DEFINITION);
		}
	}
}
