package drr.projection.iso20022.esma.emir.refit.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.regulation.esma.emir.refit.trade.PriceAndNotation;
import drr.regulation.esma.emir.refit.trade.PriceScheduleReport;
import drr.standards.iso.PriceNotationEnum;
import iso20022.auth030.esma.ActiveOrHistoricCurrencyAnd13DecimalAmount__1;
import iso20022.auth030.esma.ActiveOrHistoricCurrencyAnd19DecimalAmount;
import iso20022.auth030.esma.AmountAndDirection106;
import iso20022.auth030.esma.AmountAndDirection106__1;
import iso20022.auth030.esma.PriceData2__1;
import iso20022.auth030.esma.Schedule1;
import iso20022.auth030.esma.SecuritiesTransactionPrice17Choice;
import iso20022.auth030.esma.SecuritiesTransactionPrice17Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(GetTxPric.GetTxPricDefault.class)
public abstract class GetTxPric implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Abs abs;

	/**
	* @param drrReport 
	* @return txPric 
	*/
	public PriceData2__1 evaluate(ESMAEMIRTransactionReport drrReport) {
		PriceData2__1.PriceData2__1Builder txPricBuilder = doEvaluate(drrReport);
		
		final PriceData2__1 txPric;
		if (txPricBuilder == null) {
			txPric = null;
		} else {
			txPric = txPricBuilder.build();
			objectValidator.validate(PriceData2__1.class, txPric);
		}
		
		return txPric;
	}

	protected abstract PriceData2__1.PriceData2__1Builder doEvaluate(ESMAEMIRTransactionReport drrReport);

	public static class GetTxPricDefault extends GetTxPric {
		@Override
		protected PriceData2__1.PriceData2__1Builder doEvaluate(ESMAEMIRTransactionReport drrReport) {
			PriceData2__1.PriceData2__1Builder txPric = PriceData2__1.builder();
			return assignOutput(txPric, drrReport);
		}
		
		protected PriceData2__1.PriceData2__1Builder assignOutput(PriceData2__1.PriceData2__1Builder txPric, ESMAEMIRTransactionReport drrReport) {
			txPric
				.setPric(MapperS.of(drrReport).<PriceAndNotation>map("getPrice", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getPrice())
					.mapSingleToItem(item -> {
						AmountAndDirection106__1 ifThenElseResult1 = null;
						if (areEqual(item.<PriceNotationEnum>map("getPriceNotation", priceAndNotation -> priceAndNotation.getPriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
							Boolean ifThenElseResult0 = null;
							if (lessThan(item.<BigDecimal>map("getPriceMonetary", priceAndNotation -> priceAndNotation.getPriceMonetary()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
								ifThenElseResult0 = false;
							}
							ifThenElseResult1 = AmountAndDirection106__1.builder()
								.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount__1.builder()
									.setValue(abs.evaluate(item.<BigDecimal>map("getPriceMonetary", priceAndNotation -> priceAndNotation.getPriceMonetary()).get()))
									.setCcy(MapperS.of(drrReport).<PriceAndNotation>map("getPrice", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getPrice()).<ISOCurrencyCodeEnum>map("getPriceCurrency", priceAndNotation -> priceAndNotation.getPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
									.build())
								.setSgn(ifThenElseResult0)
								.build();
						}
						BigDecimal ifThenElseResult2 = null;
						if (areEqual(item.<PriceNotationEnum>map("getPriceNotation", priceAndNotation -> priceAndNotation.getPriceNotation()), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).getOrDefault(false)) {
							ifThenElseResult2 = item.<BigDecimal>map("getPricePercentage", priceAndNotation -> priceAndNotation.getPricePercentage()).get();
						}
						return MapperS.of(SecuritiesTransactionPrice17Choice__1.builder()
							.setMntryVal(ifThenElseResult1)
							.setPctg(ifThenElseResult2)
							.build());
					}).get());
			
			txPric
				.addSchdlPrd(MapperS.of(drrReport).<PriceScheduleReport>mapC("getPriceSchedule", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getPriceSchedule())
					.mapItem(item -> {
						Boolean ifThenElseResult = null;
						if (lessThan(item.<BigDecimal>map("getPriceMonetary", priceScheduleReport -> priceScheduleReport.getPriceMonetary()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
							ifThenElseResult = false;
						}
						return MapperS.of(Schedule1.builder()
							.setUadjstdFctvDt(item.<Date>map("getEffectiveDate", priceScheduleReport -> priceScheduleReport.getEffectiveDate()).get())
							.setUadjstdEndDt(item.<Date>map("getEndDate", priceScheduleReport -> priceScheduleReport.getEndDate()).get())
							.setPric(SecuritiesTransactionPrice17Choice.builder()
								.setMntryVal(AmountAndDirection106.builder()
									.setAmt(ActiveOrHistoricCurrencyAnd19DecimalAmount.builder()
										.setValue(abs.evaluate(item.<BigDecimal>map("getPriceMonetary", priceScheduleReport -> priceScheduleReport.getPriceMonetary()).get()))
										.setCcy(MapperS.of(drrReport).<PriceAndNotation>map("getPrice", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getPrice()).<ISOCurrencyCodeEnum>map("getPriceCurrency", priceAndNotation -> priceAndNotation.getPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
										.build())
									.setSgn(ifThenElseResult)
									.build())
								.setPctg(item.<BigDecimal>map("getPricePercentage", priceScheduleReport -> priceScheduleReport.getPricePercentage()).get())
								.build())
							.build());
					}).getMulti());
			
			return Optional.ofNullable(txPric)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
