package drr.projection.iso20022.fca.ukemir.refit.margin.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.fca.ukemir.refit.margin.CollateralReport;
import drr.regulation.fca.ukemir.refit.margin.PartiesToTheDerivative;
import iso20022.auth108.fca.Counterparty45__1;
import iso20022.auth108.fca.Counterparty46__2;
import iso20022.auth108.fca.GenericIdentification175__1;
import iso20022.auth108.fca.LegalPersonIdentification1__1;
import iso20022.auth108.fca.NaturalPersonIdentification2__1;
import iso20022.auth108.fca.NaturalPersonIdentification3__1;
import iso20022.auth108.fca.OrganisationIdentification15Choice__1;
import iso20022.auth108.fca.PartyIdentification248Choice__1;
import iso20022.auth108.fca.PartyIdentification248Choice__2;
import iso20022.auth108.fca.TradeCounterpartyReport20__2;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(Create_CounterpartySpecificData_2.Create_CounterpartySpecificData_2Default.class)
public abstract class Create_CounterpartySpecificData_2 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param partiesToTheDerivative 
	* @param collateralReport 
	* @return ctrPtySpcfcData 
	*/
	public TradeCounterpartyReport20__2 evaluate(PartiesToTheDerivative partiesToTheDerivative, CollateralReport collateralReport) {
		TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder ctrPtySpcfcDataBuilder = doEvaluate(partiesToTheDerivative, collateralReport);
		
		final TradeCounterpartyReport20__2 ctrPtySpcfcData;
		if (ctrPtySpcfcDataBuilder == null) {
			ctrPtySpcfcData = null;
		} else {
			ctrPtySpcfcData = ctrPtySpcfcDataBuilder.build();
			objectValidator.validate(TradeCounterpartyReport20__2.class, ctrPtySpcfcData);
		}
		
		return ctrPtySpcfcData;
	}

	protected abstract TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder doEvaluate(PartiesToTheDerivative partiesToTheDerivative, CollateralReport collateralReport);

	public static class Create_CounterpartySpecificData_2Default extends Create_CounterpartySpecificData_2 {
		@Override
		protected TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder doEvaluate(PartiesToTheDerivative partiesToTheDerivative, CollateralReport collateralReport) {
			TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder ctrPtySpcfcData = TradeCounterpartyReport20__2.builder();
			return assignOutput(ctrPtySpcfcData, partiesToTheDerivative, collateralReport);
		}
		
		protected TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder assignOutput(TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder ctrPtySpcfcData, PartiesToTheDerivative partiesToTheDerivative, CollateralReport collateralReport) {
			LegalPersonIdentification1__1 ifThenElseResult0 = null;
			if (areEqual(MapperS.of(partiesToTheDerivative).<Boolean>map("getCounterparty2IdentifierType", _partiesToTheDerivative -> _partiesToTheDerivative.getCounterparty2IdentifierType()), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult0 = LegalPersonIdentification1__1.builder()
					.setId(OrganisationIdentification15Choice__1.builder()
						.setLei(MapperS.of(partiesToTheDerivative).<String>map("getCounterparty2", _partiesToTheDerivative -> _partiesToTheDerivative.getCounterparty2()).get())
						.build())
					.build();
			}
			NaturalPersonIdentification3__1 ifThenElseResult1 = null;
			if (areEqual(MapperS.of(partiesToTheDerivative).<Boolean>map("getCounterparty2IdentifierType", _partiesToTheDerivative -> _partiesToTheDerivative.getCounterparty2IdentifierType()), MapperS.of(false), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult1 = NaturalPersonIdentification3__1.builder()
					.setId(NaturalPersonIdentification2__1.builder()
						.setId(GenericIdentification175__1.builder()
							.setId(MapperS.of(partiesToTheDerivative).<String>map("getCounterparty2", _partiesToTheDerivative -> _partiesToTheDerivative.getCounterparty2()).get())
							.build())
						.build())
					.build();
			}
			ctrPtySpcfcData = toBuilder(TradeCounterpartyReport20__2.builder()
				.setRptgCtrPty(Counterparty45__1.builder()
					.setId(PartyIdentification248Choice__1.builder()
						.setLgl(LegalPersonIdentification1__1.builder()
							.setId(OrganisationIdentification15Choice__1.builder()
								.setLei(MapperS.of(partiesToTheDerivative).<String>map("getCounterparty1", _partiesToTheDerivative -> _partiesToTheDerivative.getCounterparty1()).get())
								.build())
							.build())
						.build())
					.build())
				.setSubmitgAgt(OrganisationIdentification15Choice__1.builder()
					.setLei(MapperS.of(partiesToTheDerivative).<String>map("getReportSubmittingEntityID", _partiesToTheDerivative -> _partiesToTheDerivative.getReportSubmittingEntityID()).get())
					.build())
				.setOthrCtrPty(Counterparty46__2.builder()
					.setIdTp(PartyIdentification248Choice__2.builder()
						.setLgl(ifThenElseResult0)
						.setNtrl(ifThenElseResult1)
						.build())
					.build())
				.setNttyRspnsblForRpt(OrganisationIdentification15Choice__1.builder()
					.setLei(MapperS.of(partiesToTheDerivative).<String>map("getEntityResponsibleForReporting", _partiesToTheDerivative -> _partiesToTheDerivative.getEntityResponsibleForReporting()).get())
					.build())
				.build());
			
			return Optional.ofNullable(ctrPtySpcfcData)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
