package drr.projection.iso20022.fca.ukemir.refit.trade.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.util.functions.SubString;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import iso20022.auth030.fca.BasketConstituents3__1;
import iso20022.auth030.fca.ContractType14__1;
import iso20022.auth030.fca.CurrencyExchange23__1;
import iso20022.auth030.fca.CustomBasket4__1;
import iso20022.auth030.fca.FinancialInstrumentContractType2Code;
import iso20022.auth030.fca.IndexIdentification1__1;
import iso20022.auth030.fca.InstrumentIdentification6Choice__1;
import iso20022.auth030.fca.ProductType4Code__1;
import iso20022.auth030.fca.SecurityIdentification41Choice__1;
import iso20022.auth030.fca.SecurityIdentification46__1;
import iso20022.auth030.fca.UniqueProductIdentifier2Choice__1;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(Create_ContractType14__1.Create_ContractType14__1Default.class)
public abstract class Create_ContractType14__1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected SubString subString;

	/**
	* @param drrReport 
	* @return ctrctData 
	*/
	public ContractType14__1 evaluate(FCAUKEMIRTransactionReport drrReport) {
		ContractType14__1.ContractType14__1Builder ctrctDataBuilder = doEvaluate(drrReport);
		
		final ContractType14__1 ctrctData;
		if (ctrctDataBuilder == null) {
			ctrctData = null;
		} else {
			ctrctData = ctrctDataBuilder.build();
			objectValidator.validate(ContractType14__1.class, ctrctData);
		}
		
		return ctrctData;
	}

	protected abstract ContractType14__1.ContractType14__1Builder doEvaluate(FCAUKEMIRTransactionReport drrReport);

	public static class Create_ContractType14__1Default extends Create_ContractType14__1 {
		@Override
		protected ContractType14__1.ContractType14__1Builder doEvaluate(FCAUKEMIRTransactionReport drrReport) {
			ContractType14__1.ContractType14__1Builder ctrctData = ContractType14__1.builder();
			return assignOutput(ctrctData, drrReport);
		}
		
		protected ContractType14__1.ContractType14__1Builder assignOutput(ContractType14__1.ContractType14__1Builder ctrctData, FCAUKEMIRTransactionReport drrReport) {
			String ifThenElseResult0 = null;
			if (areEqual(MapperS.of(drrReport).<String>map("getUnderlyingIdentificationType", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getUnderlyingIdentificationType()), MapperS.of("I"), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult0 = MapperS.of(drrReport).<String>map("getUnderlyingIdentification", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getUnderlyingIdentification()).get();
			}
			String ifThenElseResult1 = null;
			if (areEqual(MapperS.of(drrReport).<String>map("getUnderlyingIdentificationType", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getUnderlyingIdentificationType()), MapperS.of("X"), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult1 = MapperS.of(drrReport).<String>mapC("getIndicatorOfTheUnderlyingIndex", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getIndicatorOfTheUnderlyingIndex())
					.last().get();
			}
			String ifThenElseResult2 = null;
			if (areEqual(MapperS.of(drrReport).<String>map("getUnderlyingIdentificationType", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getUnderlyingIdentificationType()), MapperS.of("X"), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult2 = MapperS.of(drrReport).<String>mapC("getNameOfTheUnderlyingIndex", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getNameOfTheUnderlyingIndex())
					.last().get();
			}
			String ifThenElseResult3 = null;
			if (areEqual(MapperS.of(drrReport).<String>map("getUnderlyingIdentificationType", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getUnderlyingIdentificationType()), MapperS.of("X"), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult3 = MapperS.of(drrReport).<String>map("getUnderlyingIdentification", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getUnderlyingIdentification()).get();
			}
			ctrctData = toBuilder(ContractType14__1.builder()
				.setPdctId(SecurityIdentification46__1.builder()
					.setIsin(MapperS.of(drrReport).<String>map("getIsin", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getIsin()).get())
					.setUnqPdctIdr(UniqueProductIdentifier2Choice__1.builder()
						.setId(MapperS.of(drrReport).<String>map("getUpi", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getUpi()).get())
						.build())
					.build())
				.setPdctClssfctn(MapperS.of(drrReport).<String>map("getProductClassification", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getProductClassification()).get())
				.setCtrctTp(MapperS.of(drrReport).<String>map("getContractType", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getContractType()).checkedMap("to-enum", FinancialInstrumentContractType2Code::fromDisplayName, IllegalArgumentException.class).get())
				.setAsstClss(MapperS.of(drrReport).<String>map("getAssetClass", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getAssetClass()).checkedMap("to-enum", ProductType4Code__1::fromDisplayName, IllegalArgumentException.class).get())
				.setDerivBasedOnCrptAsst(MapperS.of(drrReport).<Boolean>map("getIsCrypto", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getIsCrypto()).get())
				.setUndrlygInstrm(SecurityIdentification41Choice__1.builder()
					.setIsin(ifThenElseResult0)
					.setIndx(IndexIdentification1__1.builder()
						.setIndx(ifThenElseResult1)
						.setNm(ifThenElseResult2)
						.setIsin(ifThenElseResult3)
						.build())
					.setBskt(CustomBasket4__1.builder()
						.setStrr(subString.evaluate(MapperS.of(drrReport).<String>map("getCustomBasketCode", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getCustomBasketCode()).get(), 1, 20))
						.setId(subString.evaluate(MapperS.of(drrReport).<String>map("getCustomBasketCode", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getCustomBasketCode()).get(), 21, 52))
						.setCnsttnts(MapperS.of(drrReport).<String>mapC("getIdentifierOfBasketConstituents", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getIdentifierOfBasketConstituents())
							.mapItem(item -> MapperS.of(BasketConstituents3__1.builder()
								.setInstrmId(InstrumentIdentification6Choice__1.builder()
									.setIsin(item.get())
									.build())
								.build())).getMulti())
						.build())
					.build())
				.setSttlmCcy(CurrencyExchange23__1.builder()
					.setCcy(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getSettlementCurrency1", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getSettlementCurrency1()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.setSttlmCcyScndLeg(CurrencyExchange23__1.builder()
					.setCcy(MapperS.of(drrReport).<String>map("getSettlementCurrency2", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getSettlementCurrency2()).map("to-string", Object::toString).get())
					.build())
				.build());
			
			return Optional.ofNullable(ctrctData)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
