package drr.regulation.asic.rewrite.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.asic.rewrite.trade.meta.SpreadLeg1Meta;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.57.0
 */
@RosettaDataType(value="SpreadLeg1", builder=SpreadLeg1.SpreadLeg1BuilderImpl.class, version="5.57.0")
@RuneDataType(value="SpreadLeg1", model="drr", builder=SpreadLeg1.SpreadLeg1BuilderImpl.class, version="5.57.0")
public interface SpreadLeg1 extends RosettaModelObject {

	SpreadLeg1Meta metaData = new SpreadLeg1Meta();

	/*********************** Getter Methods  ***********************/
	BigDecimal getSpreadLeg1Monetary();
	BigDecimal getSpreadLeg1Decimal();
	BigDecimal getSpreadLeg1Basis();
	PriceNotationEnum getSpreadLeg1Notation();

	/*********************** Build Methods  ***********************/
	SpreadLeg1 build();
	
	SpreadLeg1.SpreadLeg1Builder toBuilder();
	
	static SpreadLeg1.SpreadLeg1Builder builder() {
		return new SpreadLeg1.SpreadLeg1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends SpreadLeg1> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends SpreadLeg1> getType() {
		return SpreadLeg1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("spreadLeg1Monetary"), BigDecimal.class, getSpreadLeg1Monetary(), this);
		processor.processBasic(path.newSubPath("spreadLeg1Decimal"), BigDecimal.class, getSpreadLeg1Decimal(), this);
		processor.processBasic(path.newSubPath("spreadLeg1Basis"), BigDecimal.class, getSpreadLeg1Basis(), this);
		processor.processBasic(path.newSubPath("spreadLeg1Notation"), PriceNotationEnum.class, getSpreadLeg1Notation(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface SpreadLeg1Builder extends SpreadLeg1, RosettaModelObjectBuilder {
		SpreadLeg1.SpreadLeg1Builder setSpreadLeg1Monetary(BigDecimal spreadLeg1Monetary);
		SpreadLeg1.SpreadLeg1Builder setSpreadLeg1Decimal(BigDecimal spreadLeg1Decimal);
		SpreadLeg1.SpreadLeg1Builder setSpreadLeg1Basis(BigDecimal spreadLeg1Basis);
		SpreadLeg1.SpreadLeg1Builder setSpreadLeg1Notation(PriceNotationEnum spreadLeg1Notation);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("spreadLeg1Monetary"), BigDecimal.class, getSpreadLeg1Monetary(), this);
			processor.processBasic(path.newSubPath("spreadLeg1Decimal"), BigDecimal.class, getSpreadLeg1Decimal(), this);
			processor.processBasic(path.newSubPath("spreadLeg1Basis"), BigDecimal.class, getSpreadLeg1Basis(), this);
			processor.processBasic(path.newSubPath("spreadLeg1Notation"), PriceNotationEnum.class, getSpreadLeg1Notation(), this);
		}
		

		SpreadLeg1.SpreadLeg1Builder prune();
	}

	/*********************** Immutable Implementation of SpreadLeg1  ***********************/
	class SpreadLeg1Impl implements SpreadLeg1 {
		private final BigDecimal spreadLeg1Monetary;
		private final BigDecimal spreadLeg1Decimal;
		private final BigDecimal spreadLeg1Basis;
		private final PriceNotationEnum spreadLeg1Notation;
		
		protected SpreadLeg1Impl(SpreadLeg1.SpreadLeg1Builder builder) {
			this.spreadLeg1Monetary = builder.getSpreadLeg1Monetary();
			this.spreadLeg1Decimal = builder.getSpreadLeg1Decimal();
			this.spreadLeg1Basis = builder.getSpreadLeg1Basis();
			this.spreadLeg1Notation = builder.getSpreadLeg1Notation();
		}
		
		@Override
		@RosettaAttribute("spreadLeg1Monetary")
		@RuneAttribute("spreadLeg1Monetary")
		public BigDecimal getSpreadLeg1Monetary() {
			return spreadLeg1Monetary;
		}
		
		@Override
		@RosettaAttribute("spreadLeg1Decimal")
		@RuneAttribute("spreadLeg1Decimal")
		public BigDecimal getSpreadLeg1Decimal() {
			return spreadLeg1Decimal;
		}
		
		@Override
		@RosettaAttribute("spreadLeg1Basis")
		@RuneAttribute("spreadLeg1Basis")
		public BigDecimal getSpreadLeg1Basis() {
			return spreadLeg1Basis;
		}
		
		@Override
		@RosettaAttribute("spreadLeg1Notation")
		@RuneAttribute("spreadLeg1Notation")
		public PriceNotationEnum getSpreadLeg1Notation() {
			return spreadLeg1Notation;
		}
		
		@Override
		public SpreadLeg1 build() {
			return this;
		}
		
		@Override
		public SpreadLeg1.SpreadLeg1Builder toBuilder() {
			SpreadLeg1.SpreadLeg1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(SpreadLeg1.SpreadLeg1Builder builder) {
			ofNullable(getSpreadLeg1Monetary()).ifPresent(builder::setSpreadLeg1Monetary);
			ofNullable(getSpreadLeg1Decimal()).ifPresent(builder::setSpreadLeg1Decimal);
			ofNullable(getSpreadLeg1Basis()).ifPresent(builder::setSpreadLeg1Basis);
			ofNullable(getSpreadLeg1Notation()).ifPresent(builder::setSpreadLeg1Notation);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			SpreadLeg1 _that = getType().cast(o);
		
			if (!Objects.equals(spreadLeg1Monetary, _that.getSpreadLeg1Monetary())) return false;
			if (!Objects.equals(spreadLeg1Decimal, _that.getSpreadLeg1Decimal())) return false;
			if (!Objects.equals(spreadLeg1Basis, _that.getSpreadLeg1Basis())) return false;
			if (!Objects.equals(spreadLeg1Notation, _that.getSpreadLeg1Notation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (spreadLeg1Monetary != null ? spreadLeg1Monetary.hashCode() : 0);
			_result = 31 * _result + (spreadLeg1Decimal != null ? spreadLeg1Decimal.hashCode() : 0);
			_result = 31 * _result + (spreadLeg1Basis != null ? spreadLeg1Basis.hashCode() : 0);
			_result = 31 * _result + (spreadLeg1Notation != null ? spreadLeg1Notation.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "SpreadLeg1 {" +
				"spreadLeg1Monetary=" + this.spreadLeg1Monetary + ", " +
				"spreadLeg1Decimal=" + this.spreadLeg1Decimal + ", " +
				"spreadLeg1Basis=" + this.spreadLeg1Basis + ", " +
				"spreadLeg1Notation=" + this.spreadLeg1Notation +
			'}';
		}
	}

	/*********************** Builder Implementation of SpreadLeg1  ***********************/
	class SpreadLeg1BuilderImpl implements SpreadLeg1.SpreadLeg1Builder {
	
		protected BigDecimal spreadLeg1Monetary;
		protected BigDecimal spreadLeg1Decimal;
		protected BigDecimal spreadLeg1Basis;
		protected PriceNotationEnum spreadLeg1Notation;
		
		@Override
		@RosettaAttribute("spreadLeg1Monetary")
		@RuneAttribute("spreadLeg1Monetary")
		public BigDecimal getSpreadLeg1Monetary() {
			return spreadLeg1Monetary;
		}
		
		@Override
		@RosettaAttribute("spreadLeg1Decimal")
		@RuneAttribute("spreadLeg1Decimal")
		public BigDecimal getSpreadLeg1Decimal() {
			return spreadLeg1Decimal;
		}
		
		@Override
		@RosettaAttribute("spreadLeg1Basis")
		@RuneAttribute("spreadLeg1Basis")
		public BigDecimal getSpreadLeg1Basis() {
			return spreadLeg1Basis;
		}
		
		@Override
		@RosettaAttribute("spreadLeg1Notation")
		@RuneAttribute("spreadLeg1Notation")
		public PriceNotationEnum getSpreadLeg1Notation() {
			return spreadLeg1Notation;
		}
		
		@RosettaAttribute("spreadLeg1Monetary")
		@RuneAttribute("spreadLeg1Monetary")
		@Override
		public SpreadLeg1.SpreadLeg1Builder setSpreadLeg1Monetary(BigDecimal _spreadLeg1Monetary) {
			this.spreadLeg1Monetary = _spreadLeg1Monetary == null ? null : _spreadLeg1Monetary;
			return this;
		}
		
		@RosettaAttribute("spreadLeg1Decimal")
		@RuneAttribute("spreadLeg1Decimal")
		@Override
		public SpreadLeg1.SpreadLeg1Builder setSpreadLeg1Decimal(BigDecimal _spreadLeg1Decimal) {
			this.spreadLeg1Decimal = _spreadLeg1Decimal == null ? null : _spreadLeg1Decimal;
			return this;
		}
		
		@RosettaAttribute("spreadLeg1Basis")
		@RuneAttribute("spreadLeg1Basis")
		@Override
		public SpreadLeg1.SpreadLeg1Builder setSpreadLeg1Basis(BigDecimal _spreadLeg1Basis) {
			this.spreadLeg1Basis = _spreadLeg1Basis == null ? null : _spreadLeg1Basis;
			return this;
		}
		
		@RosettaAttribute("spreadLeg1Notation")
		@RuneAttribute("spreadLeg1Notation")
		@Override
		public SpreadLeg1.SpreadLeg1Builder setSpreadLeg1Notation(PriceNotationEnum _spreadLeg1Notation) {
			this.spreadLeg1Notation = _spreadLeg1Notation == null ? null : _spreadLeg1Notation;
			return this;
		}
		
		@Override
		public SpreadLeg1 build() {
			return new SpreadLeg1.SpreadLeg1Impl(this);
		}
		
		@Override
		public SpreadLeg1.SpreadLeg1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SpreadLeg1.SpreadLeg1Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getSpreadLeg1Monetary()!=null) return true;
			if (getSpreadLeg1Decimal()!=null) return true;
			if (getSpreadLeg1Basis()!=null) return true;
			if (getSpreadLeg1Notation()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SpreadLeg1.SpreadLeg1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			SpreadLeg1.SpreadLeg1Builder o = (SpreadLeg1.SpreadLeg1Builder) other;
			
			
			merger.mergeBasic(getSpreadLeg1Monetary(), o.getSpreadLeg1Monetary(), this::setSpreadLeg1Monetary);
			merger.mergeBasic(getSpreadLeg1Decimal(), o.getSpreadLeg1Decimal(), this::setSpreadLeg1Decimal);
			merger.mergeBasic(getSpreadLeg1Basis(), o.getSpreadLeg1Basis(), this::setSpreadLeg1Basis);
			merger.mergeBasic(getSpreadLeg1Notation(), o.getSpreadLeg1Notation(), this::setSpreadLeg1Notation);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			SpreadLeg1 _that = getType().cast(o);
		
			if (!Objects.equals(spreadLeg1Monetary, _that.getSpreadLeg1Monetary())) return false;
			if (!Objects.equals(spreadLeg1Decimal, _that.getSpreadLeg1Decimal())) return false;
			if (!Objects.equals(spreadLeg1Basis, _that.getSpreadLeg1Basis())) return false;
			if (!Objects.equals(spreadLeg1Notation, _that.getSpreadLeg1Notation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (spreadLeg1Monetary != null ? spreadLeg1Monetary.hashCode() : 0);
			_result = 31 * _result + (spreadLeg1Decimal != null ? spreadLeg1Decimal.hashCode() : 0);
			_result = 31 * _result + (spreadLeg1Basis != null ? spreadLeg1Basis.hashCode() : 0);
			_result = 31 * _result + (spreadLeg1Notation != null ? spreadLeg1Notation.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "SpreadLeg1Builder {" +
				"spreadLeg1Monetary=" + this.spreadLeg1Monetary + ", " +
				"spreadLeg1Decimal=" + this.spreadLeg1Decimal + ", " +
				"spreadLeg1Basis=" + this.spreadLeg1Basis + ", " +
				"spreadLeg1Notation=" + this.spreadLeg1Notation +
			'}';
		}
	}
}
