package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.reports.EnrichmentDataRule;
import drr.enrichment.common.reports.UpiPostEnrichmentDataRule;
import drr.enrichment.common.reports.UpiPreEnrichmentDataRule;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.labels.ASICTradeLabelProvider;
import drr.regulation.common.TransactionReportInstruction;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.asic.rewrite.trade", body="ASIC", corpusList={"Trade"})
@RuneLabelProvider(labelProvider=ASICTradeLabelProvider.class)
@ImplementedBy(ASICTradeReportFunction.ASICTradeReportFunctionDefault.class)
public abstract class ASICTradeReportFunction implements ReportFunction<TransactionReportInstruction, ASICTransactionReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected AssetClassRule assetClassRule;
	@Inject protected BasketConstituentsRule basketConstituentsRule;
	@Inject protected BasketStructurerRule basketStructurerRule;
	@Inject protected Beneficiary1IdentifierTypeIndicatorRule beneficiary1IdentifierTypeIndicatorRule;
	@Inject protected Beneficiary1Rule beneficiary1Rule;
	@Inject protected BrokerRule brokerRule;
	@Inject protected CDSIndexAttachmentPointRule cDSIndexAttachmentPointRule;
	@Inject protected CDSIndexDetachmentPointRule cDSIndexDetachmentPointRule;
	@Inject protected CallAmountRule callAmountRule;
	@Inject protected CallCurrencyRule callCurrencyRule;
	@Inject protected CentralCounterpartyRule centralCounterpartyRule;
	@Inject protected ClearedRule clearedRule;
	@Inject protected ClearingMemberRule clearingMemberRule;
	@Inject protected ClearingTimestampRule clearingTimestampRule;
	@Inject protected CollateralPortfolioCodeInitialMarginRule collateralPortfolioCodeInitialMarginRule;
	@Inject protected CollateralPortfolioCodeVariationMarginRule collateralPortfolioCodeVariationMarginRule;
	@Inject protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
	@Inject protected ContractTypeRule contractTypeRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2IdentifierTypeIndicatorRule counterparty2IdentifierTypeIndicatorRule;
	@Inject protected Counterparty2NameRule counterparty2NameRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected CountryOfCounterparty2Rule countryOfCounterparty2Rule;
	@Inject protected CustomBasketCodeIdentifierRule customBasketCodeIdentifierRule;
	@Inject protected DayCountConventionLeg1Rule dayCountConventionLeg1Rule;
	@Inject protected DayCountConventionLeg2Rule dayCountConventionLeg2Rule;
	@Inject protected DeltaRule deltaRule;
	@Inject protected Direction1Rule direction1Rule;
	@Inject protected Direction2Leg1Rule direction2Leg1Rule;
	@Inject protected Direction2Leg2Rule direction2Leg2Rule;
	@Inject protected EffectiveDateRule effectiveDateRule;
	@Inject protected EnrichmentDataRule enrichmentDataRule;
	@Inject protected EventIdentifierRule eventIdentifierRule;
	@Inject protected EventTimestampRule eventTimestampRule;
	@Inject protected EventTypeRule eventTypeRule;
	@Inject protected ExchangeRateBasisRule exchangeRateBasisRule;
	@Inject protected ExchangeRateRule exchangeRateRule;
	@Inject protected ExecutionAgentCounterparty2DTCCRule executionAgentCounterparty2DTCCRule;
	@Inject protected ExecutionAgentOfCounterparty1Rule executionAgentOfCounterparty1Rule;
	@Inject protected ExecutionTimestampRule executionTimestampRule;
	@Inject protected ExpirationDateRule expirationDateRule;
	@Inject protected FixedRateLeg1Rule fixedRateLeg1Rule;
	@Inject protected FixedRateLeg2Rule fixedRateLeg2Rule;
	@Inject protected FloatingRateReferencePeriodLeg2Rule floatingRateReferencePeriodLeg2Rule;
	@Inject protected FloatingRateReferencePeriodMultiplierLeg2Rule floatingRateReferencePeriodMultiplierLeg2Rule;
	@Inject protected IndexFactorRule indexFactorRule;
	@Inject protected IndicatorOfTheFloatingRateLeg2Rule indicatorOfTheFloatingRateLeg2Rule;
	@Inject protected LowerBarrierPriceCurrencyRule lowerBarrierPriceCurrencyRule;
	@Inject protected LowerBarrierPriceDecimalRule lowerBarrierPriceDecimalRule;
	@Inject protected LowerBarrierPriceMonetaryRule lowerBarrierPriceMonetaryRule;
	@Inject protected LowerBarrierPriceNotationRule lowerBarrierPriceNotationRule;
	@Inject protected MaturityDateOfTheUnderlierRule maturityDateOfTheUnderlierRule;
	@Inject protected NewDerivativeTradeRepositoryRule newDerivativeTradeRepositoryRule;
	@Inject protected NextFloatingReferenceResetDateLeg1Rule nextFloatingReferenceResetDateLeg1Rule;
	@Inject protected NextFloatingReferenceResetDateLeg2Rule nextFloatingReferenceResetDateLeg2Rule;
	@Inject protected NotionalAmountLeg1Rule notionalAmountLeg1Rule;
	@Inject protected NotionalAmountLeg2Rule notionalAmountLeg2Rule;
	@Inject protected NotionalAmountScheduleLeg1Rule notionalAmountScheduleLeg1Rule;
	@Inject protected NotionalAmountScheduleLeg2Rule notionalAmountScheduleLeg2Rule;
	@Inject protected NotionalCurrencyLeg1Rule notionalCurrencyLeg1Rule;
	@Inject protected NotionalCurrencyLeg2Rule notionalCurrencyLeg2Rule;
	@Inject protected NotionalQuantityLeg1Rule notionalQuantityLeg1Rule;
	@Inject protected NotionalQuantityLeg2Rule notionalQuantityLeg2Rule;
	@Inject protected OptionPremiumAmountRule optionPremiumAmountRule;
	@Inject protected OptionPremiumCurrencyRule optionPremiumCurrencyRule;
	@Inject protected OptionPremiumPaymentDateRule optionPremiumPaymentDateRule;
	@Inject protected OtherPaymentRule otherPaymentRule;
	@Inject protected PackageIdentifierRule packageIdentifierRule;
	@Inject protected PackageTransactionPriceCurrencyRule packageTransactionPriceCurrencyRule;
	@Inject protected PackageTransactionPriceDecimalRule packageTransactionPriceDecimalRule;
	@Inject protected PackageTransactionPriceMonetaryRule packageTransactionPriceMonetaryRule;
	@Inject protected PackageTransactionPriceNotationRule packageTransactionPriceNotationRule;
	@Inject protected PackageTransactionSpreadBasisRule packageTransactionSpreadBasisRule;
	@Inject protected PackageTransactionSpreadCurrencyRule packageTransactionSpreadCurrencyRule;
	@Inject protected PackageTransactionSpreadDecimalRule packageTransactionSpreadDecimalRule;
	@Inject protected PackageTransactionSpreadMonetaryRule packageTransactionSpreadMonetaryRule;
	@Inject protected PackageTransactionSpreadNotationRule packageTransactionSpreadNotationRule;
	@Inject protected PaymentFrequencyPeriodLeg1Rule paymentFrequencyPeriodLeg1Rule;
	@Inject protected PaymentFrequencyPeriodLeg2Rule paymentFrequencyPeriodLeg2Rule;
	@Inject protected PaymentFrequencyPeriodMultiplierLeg1Rule paymentFrequencyPeriodMultiplierLeg1Rule;
	@Inject protected PaymentFrequencyPeriodMultiplierLeg2Rule paymentFrequencyPeriodMultiplierLeg2Rule;
	@Inject protected PlatformIdentifierRule platformIdentifierRule;
	@Inject protected PriceCurrencyRule priceCurrencyRule;
	@Inject protected PriceFormatDecimalRule priceFormatDecimalRule;
	@Inject protected PriceFormatMonetaryRule priceFormatMonetaryRule;
	@Inject protected PriceNotationRule priceNotationRule;
	@Inject protected PriceUnitOfMeasureRule priceUnitOfMeasureRule;
	@Inject protected PriorUTIRule priorUTIRule;
	@Inject protected PriorUtiProprietaryRule priorUtiProprietaryRule;
	@Inject protected PutAmountRule putAmountRule;
	@Inject protected PutCurrencyRule putCurrencyRule;
	@Inject protected QuantityUnitOfMeasureLeg1Rule quantityUnitOfMeasureLeg1Rule;
	@Inject protected QuantityUnitOfMeasureLeg2Rule quantityUnitOfMeasureLeg2Rule;
	@Inject protected ReportSubmittingEntityRule reportSubmittingEntityRule;
	@Inject protected ReportingEntityRule reportingEntityRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected SecondaryTransactionIdentifierRule secondaryTransactionIdentifierRule;
	@Inject protected SettlementCurrencyLeg1Rule settlementCurrencyLeg1Rule;
	@Inject protected SettlementCurrencyLeg2Rule settlementCurrencyLeg2Rule;
	@Inject protected SingleBarrierPriceCurrencyRule singleBarrierPriceCurrencyRule;
	@Inject protected SingleBarrierPriceDecimalRule singleBarrierPriceDecimalRule;
	@Inject protected SingleBarrierPriceMonetaryRule singleBarrierPriceMonetaryRule;
	@Inject protected SingleBarrierPriceNotationRule singleBarrierPriceNotationRule;
	@Inject protected SmallScaleBuySideEntityIndicatorRule smallScaleBuySideEntityIndicatorRule;
	@Inject protected SpreadCurrencyLeg1Rule spreadCurrencyLeg1Rule;
	@Inject protected SpreadCurrencyLeg2Rule spreadCurrencyLeg2Rule;
	@Inject protected SpreadLeg1BasisRule spreadLeg1BasisRule;
	@Inject protected SpreadLeg1DecimalRule spreadLeg1DecimalRule;
	@Inject protected SpreadLeg1MonetaryRule spreadLeg1MonetaryRule;
	@Inject protected SpreadLeg1NotationRule spreadLeg1NotationRule;
	@Inject protected SpreadLeg2BasisRule spreadLeg2BasisRule;
	@Inject protected SpreadLeg2DecimalRule spreadLeg2DecimalRule;
	@Inject protected SpreadLeg2MonetaryRule spreadLeg2MonetaryRule;
	@Inject protected SpreadLeg2NotationRule spreadLeg2NotationRule;
	@Inject protected SpreadNotationLeg1Rule spreadNotationLeg1Rule;
	@Inject protected SpreadNotationLeg2Rule spreadNotationLeg2Rule;
	@Inject protected StrikePriceCurrencyCurrencyPairRule strikePriceCurrencyCurrencyPairRule;
	@Inject protected StrikePriceDecimalRule strikePriceDecimalRule;
	@Inject protected StrikePriceMonetaryRule strikePriceMonetaryRule;
	@Inject protected StrikePriceNotationRule strikePriceNotationRule;
	@Inject protected TechnicalRecordIdRule technicalRecordIdRule;
	@Inject protected TotalNotionalQuantityLeg1Rule totalNotionalQuantityLeg1Rule;
	@Inject protected TotalNotionalQuantityLeg2Rule totalNotionalQuantityLeg2Rule;
	@Inject protected UnderlyingIdOtherRule underlyingIdOtherRule;
	@Inject protected UnderlyingIdOtherSourceRule underlyingIdOtherSourceRule;
	@Inject protected UnderlyingIdentificationRule underlyingIdentificationRule;
	@Inject protected UnderlyingIdentificationTypeRule underlyingIdentificationTypeRule;
	@Inject protected UniqueProductIdentifierRule uniqueProductIdentifierRule;
	@Inject protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
	@Inject protected UpiPostEnrichmentDataRule upiPostEnrichmentDataRule;
	@Inject protected UpiPreEnrichmentDataRule upiPreEnrichmentDataRule;
	@Inject protected UpperBarrierPriceCurrencyRule upperBarrierPriceCurrencyRule;
	@Inject protected UpperBarrierPriceDecimalRule upperBarrierPriceDecimalRule;
	@Inject protected UpperBarrierPriceMonetaryRule upperBarrierPriceMonetaryRule;
	@Inject protected UpperBarrierPriceNotationRule upperBarrierPriceNotationRule;
	@Inject protected UtiProprietaryRule utiProprietaryRule;
	@Inject protected ValuationAmountRule valuationAmountRule;
	@Inject protected ValuationCurrencyRule valuationCurrencyRule;
	@Inject protected ValuationMethodRule valuationMethodRule;
	@Inject protected ValuationTimestampRule valuationTimestampRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ASICTransactionReport evaluate(TransactionReportInstruction input) {
		ASICTransactionReport.ASICTransactionReportBuilder outputBuilder = doEvaluate(input);
		
		final ASICTransactionReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(ASICTransactionReport.class, output);
		}
		
		return output;
	}

	protected abstract ASICTransactionReport.ASICTransactionReportBuilder doEvaluate(TransactionReportInstruction input);

	public static class ASICTradeReportFunctionDefault extends ASICTradeReportFunction {
		@Override
		protected ASICTransactionReport.ASICTransactionReportBuilder doEvaluate(TransactionReportInstruction input) {
			ASICTransactionReport.ASICTransactionReportBuilder output = ASICTransactionReport.builder();
			return assignOutput(output, input);
		}
		
		protected ASICTransactionReport.ASICTransactionReportBuilder assignOutput(ASICTransactionReport.ASICTransactionReportBuilder output, TransactionReportInstruction input) {
			output
				.setUniqueTransactionIdentifier(uniqueTransactionIdentifierRule.evaluate(input));
			
			output
				.setUtiProprietaryID(utiProprietaryRule.evaluate(input));
			
			output
				.setSecondaryTransactionIdentifier(secondaryTransactionIdentifierRule.evaluate(input));
			
			output
				.setUniqueProductIdentifier(uniqueProductIdentifierRule.evaluate(input));
			
			output
				.setAssetClass(assetClassRule.evaluate(input));
			
			output
				.setContractType(contractTypeRule.evaluate(input));
			
			output
				.setReportingEntity(reportingEntityRule.evaluate(input));
			
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setCounterparty2Name(counterparty2NameRule.evaluate(input));
			
			output
				.setCounterparty2IdentifierTypeIndicator(counterparty2IdentifierTypeIndicatorRule.evaluate(input));
			
			output
				.setCountryOfTheCounterParty2(countryOfCounterparty2Rule.evaluate(input));
			
			output
				.setBeneficiary1(beneficiary1Rule.evaluate(input));
			
			output
				.setBeneficiary1IdentifierTypeIndicator(beneficiary1IdentifierTypeIndicatorRule.evaluate(input));
			
			output
				.setBroker(brokerRule.evaluate(input));
			
			output
				.setExecutionAgentOfCounterparty1(executionAgentOfCounterparty1Rule.evaluate(input));
			
			output
				.setDirection(direction1Rule.evaluate(input));
			
			output
				.setDirection2OfLeg1(direction2Leg1Rule.evaluate(input));
			
			output
				.setDirection2OfLeg2(direction2Leg2Rule.evaluate(input));
			
			output
				.setEffectiveDate(effectiveDateRule.evaluate(input));
			
			output
				.setExpirationDate(expirationDateRule.evaluate(input));
			
			output
				.setExecutionTimestamp(executionTimestampRule.evaluate(input));
			
			output
				.setEventTimestamp(eventTimestampRule.evaluate(input));
			
			output
				.setClearingTimestamp(clearingTimestampRule.evaluate(input));
			
			output
				.setCleared(clearedRule.evaluate(input));
			
			output
				.setCentralCounterparty(centralCounterpartyRule.evaluate(input));
			
			output
				.setClearingMember(clearingMemberRule.evaluate(input));
			
			output
				.setPlatformIdentifier(platformIdentifierRule.evaluate(input));
			
			output
				.setNotionalLeg1(notionalAmountLeg1Rule.evaluate(input));
			
			output
				.setNotionalLeg2(notionalAmountLeg2Rule.evaluate(input));
			
			output
				.setTotalNotionalQuantityLeg1(totalNotionalQuantityLeg1Rule.evaluate(input));
			
			output
				.setTotalNotionalQuantityLeg2(totalNotionalQuantityLeg2Rule.evaluate(input));
			
			output
				.setNotionalQuantityLeg1(notionalQuantityLeg1Rule.evaluate(input));
			
			output
				.setNotionalQuantityLeg2(notionalQuantityLeg2Rule.evaluate(input));
			
			output
				.setCallAmount(callAmountRule.evaluate(input));
			
			output
				.setPutAmount(putAmountRule.evaluate(input));
			
			output
				.setNotionalCurrencyLeg1(notionalCurrencyLeg1Rule.evaluate(input));
			
			output
				.setNotionalCurrencyLeg2(notionalCurrencyLeg2Rule.evaluate(input));
			
			output
				.setQuantityUnitOfMeasureLeg1(quantityUnitOfMeasureLeg1Rule.evaluate(input));
			
			output
				.setQuantityUnitOfMeasureLeg2(quantityUnitOfMeasureLeg2Rule.evaluate(input));
			
			output
				.setCallCurrency(callCurrencyRule.evaluate(input));
			
			output
				.setPutCurrency(putCurrencyRule.evaluate(input));
			
			output
				.setNotionalAmountScheduleLeg1(notionalAmountScheduleLeg1Rule.evaluate(input));
			
			output
				.setNotionalAmountScheduleLeg2(notionalAmountScheduleLeg2Rule.evaluate(input));
			
			output
				.getOrCreatePrice()
				.setPriceMonetary(priceFormatMonetaryRule.evaluate(input));
			
			output
				.getOrCreatePrice()
				.setPriceDecimal(priceFormatDecimalRule.evaluate(input));
			
			output
				.getOrCreatePrice()
				.setPriceCurrency(priceCurrencyRule.evaluate(input));
			
			output
				.getOrCreatePrice()
				.setPriceNotation(priceNotationRule.evaluate(input));
			
			output
				.setPriceUnitOfMeasure(priceUnitOfMeasureRule.evaluate(input));
			
			output
				.setFixedRateLeg1(fixedRateLeg1Rule.evaluate(input));
			
			output
				.setFixedRateLeg2(fixedRateLeg2Rule.evaluate(input));
			
			output
				.setSpreadNotationLeg1(spreadNotationLeg1Rule.evaluate(input));
			
			output
				.getOrCreateSpreadLeg1()
				.setSpreadLeg1Monetary(spreadLeg1MonetaryRule.evaluate(input));
			
			output
				.getOrCreateSpreadLeg1()
				.setSpreadLeg1Decimal(spreadLeg1DecimalRule.evaluate(input));
			
			output
				.getOrCreateSpreadLeg1()
				.setSpreadLeg1Basis(spreadLeg1BasisRule.evaluate(input));
			
			output
				.getOrCreateSpreadLeg1()
				.setSpreadLeg1Notation(spreadLeg1NotationRule.evaluate(input));
			
			output
				.setSpreadNotationLeg2(spreadNotationLeg2Rule.evaluate(input));
			
			output
				.getOrCreateSpreadLeg2()
				.setSpreadLeg2Monetary(spreadLeg2MonetaryRule.evaluate(input));
			
			output
				.getOrCreateSpreadLeg2()
				.setSpreadLeg2Decimal(spreadLeg2DecimalRule.evaluate(input));
			
			output
				.getOrCreateSpreadLeg2()
				.setSpreadLeg2Basis(spreadLeg2BasisRule.evaluate(input));
			
			output
				.getOrCreateSpreadLeg2()
				.setSpreadLeg2Notation(spreadLeg2NotationRule.evaluate(input));
			
			output
				.setSpreadCurrencyLeg1(spreadCurrencyLeg1Rule.evaluate(input));
			
			output
				.setSpreadCurrencyLeg2(spreadCurrencyLeg2Rule.evaluate(input));
			
			output
				.getOrCreateStrikePrice()
				.setStrikePriceMonetary(strikePriceMonetaryRule.evaluate(input));
			
			output
				.getOrCreateStrikePrice()
				.setStrikePriceDecimal(strikePriceDecimalRule.evaluate(input));
			
			output
				.getOrCreateStrikePrice()
				.setStrikePriceNotation(strikePriceNotationRule.evaluate(input));
			
			output
				.getOrCreateStrikePrice()
				.setStrikePriceCurrency(strikePriceCurrencyCurrencyPairRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setSingleBarrierPriceMonetary(singleBarrierPriceMonetaryRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setSingleBarrierPriceDecimal(singleBarrierPriceDecimalRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setLowerBarrierPriceMonetary(lowerBarrierPriceMonetaryRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setLowerBarrierPriceDecimal(lowerBarrierPriceDecimalRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setUpperBarrierPriceMonetary(upperBarrierPriceMonetaryRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setUpperBarrierPriceDecimal(upperBarrierPriceDecimalRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setSingleBarrierPriceNotation(singleBarrierPriceNotationRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setLowerBarrierPriceNotation(lowerBarrierPriceNotationRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setUpperBarrierPriceNotation(upperBarrierPriceNotationRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setSingleBarrierPriceCurrency(singleBarrierPriceCurrencyRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setLowerBarrierPriceCurrency(MapperC.of(lowerBarrierPriceCurrencyRule.evaluate(input)).get());
			
			output
				.getOrCreateBarrier()
				.setUpperBarrierPriceCurrency(MapperC.of(upperBarrierPriceCurrencyRule.evaluate(input)).get());
			
			output
				.setOptionPremiumAmount(optionPremiumAmountRule.evaluate(input));
			
			output
				.setOptionPremiumCurrency(optionPremiumCurrencyRule.evaluate(input));
			
			output
				.setOptionPremiumPaymentDate(optionPremiumPaymentDateRule.evaluate(input));
			
			output
				.setExchangeRate(exchangeRateRule.evaluate(input));
			
			output
				.setExchangeRateBasis(exchangeRateBasisRule.evaluate(input));
			
			output
				.setDayCountConventionLeg1(dayCountConventionLeg1Rule.evaluate(input));
			
			output
				.setDayCountConventionLeg2(dayCountConventionLeg2Rule.evaluate(input));
			
			output
				.setPaymentFrequencyPeriodLeg1(paymentFrequencyPeriodLeg1Rule.evaluate(input));
			
			output
				.setPaymentFrequencyPeriodLeg2(paymentFrequencyPeriodLeg2Rule.evaluate(input));
			
			final BigDecimal bigDecimal0 = paymentFrequencyPeriodMultiplierLeg1Rule.evaluate(input);
			output
				.setPaymentFrequencyPeriodMultiplierLeg1((bigDecimal0 == null ? null : bigDecimal0.intValueExact()));
			
			final BigDecimal bigDecimal1 = paymentFrequencyPeriodMultiplierLeg2Rule.evaluate(input);
			output
				.setPaymentFrequencyPeriodMultiplierLeg2((bigDecimal1 == null ? null : bigDecimal1.intValueExact()));
			
			output
				.setSettlementCurrencyLeg1(settlementCurrencyLeg1Rule.evaluate(input));
			
			output
				.setSettlementCurrencyLeg2(settlementCurrencyLeg2Rule.evaluate(input));
			
			output
				.setOtherPayment(otherPaymentRule.evaluate(input));
			
			output
				.getOrCreateCustomBasketCode()
				.setBasketStructurerID(basketStructurerRule.evaluate(input));
			
			output
				.getOrCreateCustomBasketCode()
				.setCustomBasketID(customBasketCodeIdentifierRule.evaluate(input));
			
			output
				.getOrCreateBasket()
				.setBasketConstituents(basketConstituentsRule.evaluate(input));
			
			output
				.setUnderlyingIdentification(underlyingIdentificationRule.evaluate(input));
			
			output
				.setUnderlyingIdentificationType(underlyingIdentificationTypeRule.evaluate(input));
			
			output
				.setUnderlyingIdOther(underlyingIdOtherRule.evaluate(input));
			
			output
				.setUnderlyingIdOtherSource(underlyingIdOtherSourceRule.evaluate(input));
			
			output
				.setMaturityDateOfTheUnderlying(maturityDateOfTheUnderlierRule.evaluate(input));
			
			output
				.setIndicatorOfTheFloatingRateLeg2(indicatorOfTheFloatingRateLeg2Rule.evaluate(input));
			
			output
				.setFloatingRateReferencePeriodOfLeg2TimePeriod(floatingRateReferencePeriodLeg2Rule.evaluate(input));
			
			final BigDecimal bigDecimal2 = floatingRateReferencePeriodMultiplierLeg2Rule.evaluate(input);
			output
				.setFloatingRateReferencePeriodOfLeg2Multiplier((bigDecimal2 == null ? null : bigDecimal2.intValueExact()));
			
			output
				.setCdSIndexAttachmentPoint(cDSIndexAttachmentPointRule.evaluate(input));
			
			output
				.setCdSIndexDetachmentPoint(cDSIndexDetachmentPointRule.evaluate(input));
			
			output
				.setIndexFactor(indexFactorRule.evaluate(input));
			
			output
				.setPackageIdentifier(packageIdentifierRule.evaluate(input));
			
			output
				.getOrCreatePackageTransactionPrice()
				.setPackageTransactionPriceMonetary(packageTransactionPriceMonetaryRule.evaluate(input));
			
			output
				.getOrCreatePackageTransactionPrice()
				.setPackageTransactionPriceDecimal(packageTransactionPriceDecimalRule.evaluate(input));
			
			output
				.getOrCreatePackageTransactionPrice()
				.setPackageTransactionPriceNotation(packageTransactionPriceNotationRule.evaluate(input));
			
			output
				.getOrCreatePackageTransactionPrice()
				.setPackageTransactionPriceCurrency(packageTransactionPriceCurrencyRule.evaluate(input));
			
			output
				.getOrCreatePackageTransactionSpread()
				.setPackageTransactionSpreadMonetary(packageTransactionSpreadMonetaryRule.evaluate(input));
			
			output
				.getOrCreatePackageTransactionSpread()
				.setPackageTransactionSpreadDecimal(packageTransactionSpreadDecimalRule.evaluate(input));
			
			output
				.getOrCreatePackageTransactionSpread()
				.setPackageTransactionSpreadBasis(packageTransactionSpreadBasisRule.evaluate(input));
			
			output
				.getOrCreatePackageTransactionSpread()
				.setPackageTransactionSpreadNotation(packageTransactionSpreadNotationRule.evaluate(input));
			
			output
				.getOrCreatePackageTransactionSpread()
				.setPackageTransactionSpreadCurrency(packageTransactionSpreadCurrencyRule.evaluate(input));
			
			output
				.setPriorUTI(priorUTIRule.evaluate(input));
			
			output
				.setPriorUtiProprietary(priorUtiProprietaryRule.evaluate(input));
			
			output
				.setEventIdentifier(eventIdentifierRule.evaluate(input));
			
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setEventType(eventTypeRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setReportSubmittingEntityID(reportSubmittingEntityRule.evaluate(input));
			
			output
				.setNewDerivativeTradeRepository(newDerivativeTradeRepositoryRule.evaluate(input));
			
			output
				.setValuationTimestamp(valuationTimestampRule.evaluate(input));
			
			output
				.setValuationAmount(valuationAmountRule.evaluate(input));
			
			output
				.setValuationCurrency(valuationCurrencyRule.evaluate(input));
			
			output
				.setValuationMethod(valuationMethodRule.evaluate(input));
			
			output
				.setDelta(deltaRule.evaluate(input));
			
			output
				.setNextFloatingReferenceResetDateLeg1(nextFloatingReferenceResetDateLeg1Rule.evaluate(input));
			
			output
				.setNextFloatingReferenceResetDateLeg2(nextFloatingReferenceResetDateLeg2Rule.evaluate(input));
			
			output
				.setSmallScaleBuySideEntityIndicator(smallScaleBuySideEntityIndicatorRule.evaluate(input));
			
			output
				.setTechnicalRecordId(technicalRecordIdRule.evaluate(input));
			
			output
				.setCollateralPortfolioIndicator(collateralPortfolioIndicatorRule.evaluate(input));
			
			output
				.setCollateralPortfolioCodeInitialMargin(collateralPortfolioCodeInitialMarginRule.evaluate(input));
			
			output
				.setCollateralPortfolioCodeVariationMargin(collateralPortfolioCodeVariationMarginRule.evaluate(input));
			
			output
				.setExecutionAgentOfCounterparty2DTCC(executionAgentCounterparty2DTCCRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setEnrichment(enrichmentDataRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setPreUpiData(upiPreEnrichmentDataRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setPostUpiData(upiPostEnrichmentDataRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
