package drr.regulation.asic.rewrite.trade.reports;

import cdm.base.math.functions.Max;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.observable.event.FeaturePayment;
import cdm.observable.event.Trigger;
import cdm.observable.event.TriggerEvent;
import cdm.product.template.Knock;
import cdm.product.template.OptionFeature;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsOption;
import drr.regulation.common.functions.ProductForEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(UpperBarrierPriceCurrencyRule.UpperBarrierPriceCurrencyRuleDefault.class)
public abstract class UpperBarrierPriceCurrencyRule implements ReportFunction<TransactionReportInstruction, List<ISOCurrencyCodeEnum>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;
	@Inject protected IsOption isOption;
	@Inject protected Max max;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<ISOCurrencyCodeEnum> evaluate(TransactionReportInstruction input) {
		List<ISOCurrencyCodeEnum> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<ISOCurrencyCodeEnum> doEvaluate(TransactionReportInstruction input);

	public static class UpperBarrierPriceCurrencyRuleDefault extends UpperBarrierPriceCurrencyRule {
		@Override
		protected List<ISOCurrencyCodeEnum> doEvaluate(TransactionReportInstruction input) {
			List<ISOCurrencyCodeEnum> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<ISOCurrencyCodeEnum> assignOutput(List<ISOCurrencyCodeEnum> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			final MapperS<Knock> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					if (ComparisonResult.ofNullSafe(MapperS.of(isOption.evaluate(productForEvent.evaluate(item.get())))).andNullSafe(exists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>mapC("getKnockIn", knock -> knock.getKnockIn()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevel", trigger -> trigger.getLevel()))).andNullSafe(exists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>mapC("getKnockOut", knock -> knock.getKnockOut()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevel", trigger -> trigger.getLevel()))).getOrDefault(false)) {
						return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).get());
					}
					return MapperS.<Knock>ofNull();
				});
			final MapperC<FieldWithMetaString> ifThenElseResult;
			if (areEqual(thenArg1.<TriggerEvent>mapC("getKnockIn", knock -> knock.getKnockIn()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevel", trigger -> trigger.getLevel()), MapperS.of(max.evaluate(thenArg1.<TriggerEvent>mapC("getKnockIn", knock -> knock.getKnockIn()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevel", trigger -> trigger.getLevel()).get(), thenArg1.<TriggerEvent>mapC("getKnockOut", knock -> knock.getKnockOut()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevel", trigger -> trigger.getLevel()).get())), CardinalityOperator.Any).getOrDefault(false)) {
				ifThenElseResult = thenArg1.<TriggerEvent>mapC("getKnockIn", knock -> knock.getKnockIn()).<FeaturePayment>map("getFeaturePayment", triggerEvent -> triggerEvent.getFeaturePayment()).<FieldWithMetaString>map("getCurrency", featurePayment -> featurePayment.getCurrency());
			} else {
				ifThenElseResult = thenArg1.<TriggerEvent>mapC("getKnockOut", knock -> knock.getKnockOut()).<FeaturePayment>map("getFeaturePayment", triggerEvent -> triggerEvent.getFeaturePayment()).<FieldWithMetaString>map("getCurrency", featurePayment -> featurePayment.getCurrency());
			}
			output = ifThenElseResult
				.mapItem(item -> {
					final FieldWithMetaString fieldWithMetaString = item.get();
					return MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString == null ? null : fieldWithMetaString.getValue())));
				}).getMulti();
			
			return output;
		}
	}
}
