package drr.regulation.asic.rewrite.trade.validation;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICCustomBasket;
import drr.regulation.asic.rewrite.trade.ASICNonReportable;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.BarrierAndNotation;
import drr.regulation.asic.rewrite.trade.Basket;
import drr.regulation.asic.rewrite.trade.PackageTransactionPrice;
import drr.regulation.asic.rewrite.trade.PackageTransactionSpread;
import drr.regulation.asic.rewrite.trade.PriceAndNotation;
import drr.regulation.asic.rewrite.trade.SpreadLeg1;
import drr.regulation.asic.rewrite.trade.SpreadLeg2;
import drr.regulation.asic.rewrite.trade.StrikePriceAndNotation;
import iso20022.auth030.asic.InterestComputationMethod4Code;
import iso20022.auth030.asic.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class ASICTransactionReportValidator implements Validator<ASICTransactionReport> {

	private List<ComparisonResult> getComparisonResults(ASICTransactionReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("uniqueTransactionIdentifier", (String) o.getUniqueTransactionIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("utiProprietaryID", (String) o.getUtiProprietaryID() != null ? 1 : 0, 0, 1), 
				checkCardinality("secondaryTransactionIdentifier", (String) o.getSecondaryTransactionIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("uniqueProductIdentifier", (String) o.getUniqueProductIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("assetClass", (String) o.getAssetClass() != null ? 1 : 0, 1, 1), 
				checkCardinality("contractType", (String) o.getContractType() != null ? 1 : 0, 1, 1), 
				checkCardinality("reportingEntity", (String) o.getReportingEntity() != null ? 1 : 0, 0, 1), 
				checkCardinality("counterparty1", (String) o.getCounterparty1() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2", (String) o.getCounterparty2() != null ? 1 : 0, 0, 1), 
				checkCardinality("counterparty2Name", (String) o.getCounterparty2Name() != null ? 1 : 0, 0, 1), 
				checkCardinality("counterparty2IdentifierTypeIndicator", (Boolean) o.getCounterparty2IdentifierTypeIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("countryOfTheCounterParty2", (ISOCountryCodeEnum) o.getCountryOfTheCounterParty2() != null ? 1 : 0, 0, 1), 
				checkCardinality("beneficiary1", (String) o.getBeneficiary1() != null ? 1 : 0, 0, 1), 
				checkCardinality("beneficiary1IdentifierTypeIndicator", (Boolean) o.getBeneficiary1IdentifierTypeIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("broker", (String) o.getBroker() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionAgentOfCounterparty1", (String) o.getExecutionAgentOfCounterparty1() != null ? 1 : 0, 0, 1), 
				checkCardinality("direction", (String) o.getDirection() != null ? 1 : 0, 0, 1), 
				checkCardinality("direction2OfLeg1", (String) o.getDirection2OfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("direction2OfLeg2", (String) o.getDirection2OfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("effectiveDate", (Date) o.getEffectiveDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("expirationDate", (Date) o.getExpirationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionTimestamp", (ZonedDateTime) o.getExecutionTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("eventTimestamp", (ZonedDateTime) o.getEventTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("clearingTimestamp", (ZonedDateTime) o.getClearingTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("cleared", (String) o.getCleared() != null ? 1 : 0, 0, 1), 
				checkCardinality("centralCounterparty", (String) o.getCentralCounterparty() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingMember", (String) o.getClearingMember() != null ? 1 : 0, 0, 1), 
				checkCardinality("platformIdentifier", (String) o.getPlatformIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalLeg1", (BigDecimal) o.getNotionalLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalLeg2", (BigDecimal) o.getNotionalLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("totalNotionalQuantityLeg1", (BigDecimal) o.getTotalNotionalQuantityLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("totalNotionalQuantityLeg2", (BigDecimal) o.getTotalNotionalQuantityLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalQuantityLeg1", (BigDecimal) o.getNotionalQuantityLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalQuantityLeg2", (BigDecimal) o.getNotionalQuantityLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("callAmount", (BigDecimal) o.getCallAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("putAmount", (BigDecimal) o.getPutAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalCurrencyLeg1", (ISOCurrencyCodeEnum) o.getNotionalCurrencyLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalCurrencyLeg2", (ISOCurrencyCodeEnum) o.getNotionalCurrencyLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityUnitOfMeasureLeg1", (String) o.getQuantityUnitOfMeasureLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityUnitOfMeasureLeg2", (String) o.getQuantityUnitOfMeasureLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("callCurrency", (ISOCurrencyCodeEnum) o.getCallCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("putCurrency", (ISOCurrencyCodeEnum) o.getPutCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("price", (PriceAndNotation) o.getPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("priceUnitOfMeasure", (String) o.getPriceUnitOfMeasure() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateLeg1", (BigDecimal) o.getFixedRateLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateLeg2", (BigDecimal) o.getFixedRateLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadNotationLeg1", (String) o.getSpreadNotationLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadLeg1", (SpreadLeg1) o.getSpreadLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadNotationLeg2", (String) o.getSpreadNotationLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadLeg2", (SpreadLeg2) o.getSpreadLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadCurrencyLeg1", (ISOCurrencyCodeEnum) o.getSpreadCurrencyLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadCurrencyLeg2", (ISOCurrencyCodeEnum) o.getSpreadCurrencyLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePrice", (StrikePriceAndNotation) o.getStrikePrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("barrier", (BarrierAndNotation) o.getBarrier() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionPremiumAmount", (BigDecimal) o.getOptionPremiumAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionPremiumCurrency", (ISOCurrencyCodeEnum) o.getOptionPremiumCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionPremiumPaymentDate", (Date) o.getOptionPremiumPaymentDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("exchangeRate", (BigDecimal) o.getExchangeRate() != null ? 1 : 0, 0, 1), 
				checkCardinality("exchangeRateBasis", (String) o.getExchangeRateBasis() != null ? 1 : 0, 0, 1), 
				checkCardinality("dayCountConventionLeg1", (InterestComputationMethod4Code) o.getDayCountConventionLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("dayCountConventionLeg2", (InterestComputationMethod4Code) o.getDayCountConventionLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("paymentFrequencyPeriodLeg1", (String) o.getPaymentFrequencyPeriodLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("paymentFrequencyPeriodLeg2", (String) o.getPaymentFrequencyPeriodLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("paymentFrequencyPeriodMultiplierLeg1", (Integer) o.getPaymentFrequencyPeriodMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("paymentFrequencyPeriodMultiplierLeg2", (Integer) o.getPaymentFrequencyPeriodMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementCurrencyLeg1", (ISOCurrencyCodeEnum) o.getSettlementCurrencyLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementCurrencyLeg2", (ISOCurrencyCodeEnum) o.getSettlementCurrencyLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("customBasketCode", (ASICCustomBasket) o.getCustomBasketCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("basket", (Basket) o.getBasket() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingIdentification", (String) o.getUnderlyingIdentification() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingIdentificationType", (String) o.getUnderlyingIdentificationType() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingIdOther", (String) o.getUnderlyingIdOther() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingIdOtherSource", (ProductIdTypeEnum) o.getUnderlyingIdOtherSource() != null ? 1 : 0, 0, 1), 
				checkCardinality("maturityDateOfTheUnderlying", (Date) o.getMaturityDateOfTheUnderlying() != null ? 1 : 0, 0, 1), 
				checkCardinality("indicatorOfTheFloatingRateLeg2", (String) o.getIndicatorOfTheFloatingRateLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateReferencePeriodOfLeg2TimePeriod", (String) o.getFloatingRateReferencePeriodOfLeg2TimePeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateReferencePeriodOfLeg2Multiplier", (Integer) o.getFloatingRateReferencePeriodOfLeg2Multiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdSIndexAttachmentPoint", (BigDecimal) o.getCdSIndexAttachmentPoint() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdSIndexDetachmentPoint", (BigDecimal) o.getCdSIndexDetachmentPoint() != null ? 1 : 0, 0, 1), 
				checkCardinality("indexFactor", (BigDecimal) o.getIndexFactor() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageIdentifier", (String) o.getPackageIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionPrice", (PackageTransactionPrice) o.getPackageTransactionPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionSpread", (PackageTransactionSpread) o.getPackageTransactionSpread() != null ? 1 : 0, 0, 1), 
				checkCardinality("priorUTI", (String) o.getPriorUTI() != null ? 1 : 0, 0, 1), 
				checkCardinality("priorUtiProprietary", (String) o.getPriorUtiProprietary() != null ? 1 : 0, 0, 1), 
				checkCardinality("eventIdentifier", (String) o.getEventIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("actionType", (String) o.getActionType() != null ? 1 : 0, 1, 1), 
				checkCardinality("eventType", (String) o.getEventType() != null ? 1 : 0, 0, 1), 
				checkCardinality("reportingTimestamp", (ZonedDateTime) o.getReportingTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("reportSubmittingEntityID", (String) o.getReportSubmittingEntityID() != null ? 1 : 0, 1, 1), 
				checkCardinality("newDerivativeTradeRepository", (String) o.getNewDerivativeTradeRepository() != null ? 1 : 0, 0, 1), 
				checkCardinality("valuationTimestamp", (ZonedDateTime) o.getValuationTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("valuationAmount", (BigDecimal) o.getValuationAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("valuationCurrency", (ISOCurrencyCodeEnum) o.getValuationCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("valuationMethod", (ValuationType1Code) o.getValuationMethod() != null ? 1 : 0, 0, 1), 
				checkCardinality("delta", (BigDecimal) o.getDelta() != null ? 1 : 0, 0, 1), 
				checkCardinality("nextFloatingReferenceResetDateLeg1", (Date) o.getNextFloatingReferenceResetDateLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("nextFloatingReferenceResetDateLeg2", (Date) o.getNextFloatingReferenceResetDateLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("smallScaleBuySideEntityIndicator", (String) o.getSmallScaleBuySideEntityIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("technicalRecordId", (String) o.getTechnicalRecordId() != null ? 1 : 0, 1, 1), 
				checkCardinality("collateralPortfolioIndicator", (Boolean) o.getCollateralPortfolioIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("collateralPortfolioCodeInitialMargin", (String) o.getCollateralPortfolioCodeInitialMargin() != null ? 1 : 0, 0, 1), 
				checkCardinality("collateralPortfolioCodeVariationMargin", (String) o.getCollateralPortfolioCodeVariationMargin() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionAgentOfCounterparty2DTCC", (String) o.getExecutionAgentOfCounterparty2DTCC() != null ? 1 : 0, 0, 1), 
				checkCardinality("nonReportable", (ASICNonReportable) o.getNonReportable() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ASICTransactionReport", ValidationResult.ValidationType.CARDINALITY, "ASICTransactionReport", path, "", res.getError());
				}
				return success("ASICTransactionReport", ValidationResult.ValidationType.CARDINALITY, "ASICTransactionReport", path, "");
			})
			.collect(toList());
	}

}
