package drr.regulation.asic.rewrite.trade.validation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.BarrierAndNotation;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class BarrierAndNotationValidator implements Validator<BarrierAndNotation> {

	private List<ComparisonResult> getComparisonResults(BarrierAndNotation o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("singleBarrierPriceMonetary", (BigDecimal) o.getSingleBarrierPriceMonetary() != null ? 1 : 0, 0, 1), 
				checkCardinality("singleBarrierPriceDecimal", (BigDecimal) o.getSingleBarrierPriceDecimal() != null ? 1 : 0, 0, 1), 
				checkCardinality("lowerBarrierPriceMonetary", (BigDecimal) o.getLowerBarrierPriceMonetary() != null ? 1 : 0, 0, 1), 
				checkCardinality("lowerBarrierPriceDecimal", (BigDecimal) o.getLowerBarrierPriceDecimal() != null ? 1 : 0, 0, 1), 
				checkCardinality("upperBarrierPriceMonetary", (BigDecimal) o.getUpperBarrierPriceMonetary() != null ? 1 : 0, 0, 1), 
				checkCardinality("upperBarrierPriceDecimal", (BigDecimal) o.getUpperBarrierPriceDecimal() != null ? 1 : 0, 0, 1), 
				checkCardinality("singleBarrierPriceNotation", (PriceNotationEnum) o.getSingleBarrierPriceNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("lowerBarrierPriceNotation", (PriceNotationEnum) o.getLowerBarrierPriceNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("upperBarrierPriceNotation", (PriceNotationEnum) o.getUpperBarrierPriceNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("singleBarrierPriceCurrency", (ISOCurrencyCodeEnum) o.getSingleBarrierPriceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("lowerBarrierPriceCurrency", (ISOCurrencyCodeEnum) o.getLowerBarrierPriceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("upperBarrierPriceCurrency", (ISOCurrencyCodeEnum) o.getUpperBarrierPriceCurrency() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, BarrierAndNotation o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("BarrierAndNotation", ValidationResult.ValidationType.CARDINALITY, "BarrierAndNotation", path, "", res.getError());
				}
				return success("BarrierAndNotation", ValidationResult.ValidationType.CARDINALITY, "BarrierAndNotation", path, "");
			})
			.collect(toList());
	}

}
