package drr.regulation.asic.rewrite.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.SpreadLeg2;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class SpreadLeg2TypeFormatValidator implements Validator<SpreadLeg2> {

	private List<ComparisonResult> getComparisonResults(SpreadLeg2 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkNumber("spreadLeg2Monetary", o.getSpreadLeg2Monetary(), of(18), of(13), empty(), empty()), 
				checkNumber("spreadLeg2Decimal", o.getSpreadLeg2Decimal(), of(11), of(10), empty(), empty()), 
				checkNumber("spreadLeg2Basis", o.getSpreadLeg2Basis(), of(5), empty(), empty(), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadLeg2 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("SpreadLeg2", ValidationResult.ValidationType.TYPE_FORMAT, "SpreadLeg2", path, "", res.getError());
				}
				return success("SpreadLeg2", ValidationResult.ValidationType.TYPE_FORMAT, "SpreadLeg2", path, "");
			})
			.collect(toList());
	}

}
